/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.util.Iterator;
import java.util.LinkedList;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;

class LinkedRPObjectList
extends LinkedList<RPObject> {
    private static final long serialVersionUID = -7221795029536087812L;
    private static final Logger logger = Log4J.getLogger(LinkedRPObjectList.class);

    LinkedRPObjectList() {
    }

    public RPObject getByIDIgnoringZone(RPObject.ID iD) {
        int n = iD.getObjectID();
        for (RPObject rPObject : this) {
            if (rPObject.getID().getObjectID() != n) continue;
            return rPObject;
        }
        return null;
    }

    public boolean hasByIDIgnoringZone(RPObject.ID iD) {
        int n = iD.getObjectID();
        for (RPObject rPObject : this) {
            if (n != rPObject.getID().getObjectID()) continue;
            return true;
        }
        return false;
    }

    public RPObject removeByIDIgnoringZone(RPObject.ID iD) {
        int n = iD.getObjectID();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RPObject rPObject = (RPObject)iterator.next();
            if (rPObject.getID().getObjectID() != n) continue;
            iterator.remove();
            return rPObject;
        }
        return null;
    }

    @Override
    public boolean add(RPObject rPObject) {
        this.checkObjectNotAllreadyInList(rPObject);
        return super.add(rPObject);
    }

    boolean addTrusted(RPObject rPObject) {
        return super.add(rPObject);
    }

    private void checkObjectNotAllreadyInList(RPObject rPObject) {
        RPObject.ID iD = rPObject.getID();
        RPObject rPObject2 = this.getByIDIgnoringZone(iD);
        if (rPObject2 != null) {
            if (rPObject2 == rPObject) {
                logger.error("Object cannot be added to list because it is already part of it: " + rPObject, new Throwable());
            } else {
                logger.error("Object cannot be added to list because another object with the same ID is part of it. objectToAdd: " + rPObject + " objectAlreadyInList: " + rPObject2, new Throwable());
            }
        }
    }
}

