/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.io.FileSystemPersistence;

public abstract class Persistence {
    private static final Logger logger = Log4J.getLogger(Persistence.class);
    private static Persistence instance = null;
    private static boolean WEB_START_SANDBOX = false;

    public static Persistence get() {
        if (instance == null) {
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                WEB_START_SANDBOX = true;
            }
            catch (Error error) {
                WEB_START_SANDBOX = true;
            }
            if (WEB_START_SANDBOX) {
                try {
                    Class<?> clazz = Class.forName("marauroa.common.io.WebstartPersistence");
                    instance = (Persistence)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    logger.error(exception, exception);
                }
            } else {
                instance = new FileSystemPersistence();
            }
        }
        return instance;
    }

    public abstract InputStream getInputStream(boolean var1, String var2, String var3) throws IOException;

    public abstract OutputStream getOutputStream(boolean var1, String var2, String var3) throws IOException;
}

