/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net;

import java.io.IOException;
import java.io.InputStream;
import marauroa.common.net.Serializable;

public class InputSerializer {
    private final InputStream in;
    private int protocolVersion = 35;

    public InputSerializer(InputStream inputStream) {
        this.in = inputStream;
    }

    public Object readObject(Serializable serializable) throws IOException {
        serializable.readObject(this);
        return serializable;
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new IOException();
        }
        return (byte)n;
    }

    public byte[] readByteArray() throws IOException {
        int n;
        int n2 = this.readInt();
        if (n2 > 262144) {
            throw new IOException("Illegal request of an array of " + n2 + " size");
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actually read bytes count(" + n + ")!");
        }
        return byArray;
    }

    private static int byteToPositiveInt(byte by) {
        return by & 0xFF;
    }

    public byte[] read255LongByteArray() throws IOException {
        int n;
        int n2 = InputSerializer.byteToPositiveInt(this.readByte());
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actually read bytes count(" + n + ")!");
        }
        return byArray;
    }

    public byte[] read65536LongByteArray() throws IOException {
        int n;
        int n2 = this.readShort();
        if (n2 < 0) {
            throw new IOException("Illegal request of an array of " + n2 + " size");
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actually read bytes count(" + n + ")!");
        }
        return byArray;
    }

    public short readShort() throws IOException {
        int n;
        int n2 = 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actually read bytes count(" + n + ")!");
        }
        int n4 = byArray[0] & 0xFF;
        return (short)(n4 += (byArray[1] & 0xFF) << 8);
    }

    public int readInt() throws IOException {
        int n;
        int n2 = 4;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actually read bytes count(" + n + ")!");
        }
        int n4 = byArray[0] & 0xFF;
        n4 += (byArray[1] & 0xFF) << 8;
        n4 += (byArray[2] & 0xFF) << 16;
        return n4 += (byArray[3] & 0xFF) << 24;
    }

    public long readLong() throws IOException {
        int n;
        int n2 = 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actual read bytes count(" + n + ")!");
        }
        long l = byArray[0] & 0xFF;
        l += (long)((byArray[1] & 0xFF) << 8);
        l += (long)((byArray[2] & 0xFF) << 16);
        l += (long)((byArray[3] & 0xFF) << 24);
        l += (long)((byArray[4] & 0xFF) << 32);
        l += (long)((byArray[5] & 0xFF) << 40);
        l += (long)((byArray[6] & 0xFF) << 48);
        return l += (long)((byArray[7] & 0xFF) << 56);
    }

    public float readFloat() throws IOException {
        int n;
        int n2 = 4;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < n2 && (n3 = this.in.read(byArray, n, n2 - n)) != -1; n += n3) {
        }
        if (n != n2) {
            throw new IOException("Declared array size=" + n2 + " is not equal to actually read bytes count(" + n + ")!");
        }
        int n4 = byArray[0] & 0xFF;
        n4 += (byArray[1] & 0xFF) << 8;
        n4 += (byArray[2] & 0xFF) << 16;
        return Float.intBitsToFloat(n4 += (byArray[3] & 0xFF) << 24);
    }

    public String readString() throws IOException {
        return new String(this.readByteArray(), "UTF-8");
    }

    public String read255LongString() throws IOException {
        return new String(this.read255LongByteArray(), "UTF-8");
    }

    public String read65536LongString() throws IOException {
        return new String(this.read65536LongByteArray(), "UTF-8");
    }

    public String[] readStringArray() throws IOException {
        int n = this.readInt();
        if (n > 262144) {
            throw new IOException("Illegal request of an array of " + String.valueOf(n) + " size");
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readString();
        }
        return stringArray;
    }

    public Object[] readObjectArray(Class<? extends Serializable> clazz) throws IOException {
        int n = this.readInt();
        if (n > 262144) {
            throw new IOException("Illegal request of an array of " + String.valueOf(n) + " size");
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            try {
                serializable = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException(instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException.toString());
            }
            objectArray[i] = this.readObject(serializable);
        }
        return objectArray;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    public int available() {
        try {
            return this.in.available();
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

