/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.Map;
import marauroa.common.crypto.Hash;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageSendByteArray;

public class MessageC2SLoginSendUsernameAndPassword
extends MessageSendByteArray {
    private String username;
    private byte[] password;

    public MessageC2SLoginSendUsernameAndPassword() {
        super(Message.MessageType.C2S_LOGIN_SENDUSERNAMEANDPASSWORD);
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public String toString() {
        return "Message (C2S Login) from (" + this.getAddress() + ") CONTENTS: (nonce:" + Hash.toHexString(this.hash) + "\tusername:" + this.username + "\tpassword:" + Hash.toHexString(Hash.hash(this.password)) + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.username);
        outputSerializer.write(this.password);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.username = inputSerializer.readString();
        this.password = Hash.hash(inputSerializer.readString());
        if (this.type != Message.MessageType.C2S_LOGIN_SENDUSERNAMEANDPASSWORD) {
            throw new IOException();
        }
    }

    @Override
    public void readFromMap(Map<String, Object> map) throws IOException {
        super.readFromMap(map);
        this.username = (String)map.get("u");
        this.password = Hash.hash((String)map.get("p"));
        if (this.type != Message.MessageType.C2S_LOGIN_SENDUSERNAMEANDPASSWORD) {
            throw new IOException();
        }
    }
}

