/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CLoginACK
extends Message {
    private List<String> previousLogins;

    public MessageS2CLoginACK() {
        super(Message.MessageType.S2C_LOGIN_ACK, null);
    }

    public MessageS2CLoginACK(Channel channel, List<String> list) {
        super(Message.MessageType.S2C_LOGIN_ACK, channel);
        this.previousLogins = list;
    }

    public List<String> getPreviousLogins() {
        return this.previousLogins;
    }

    @Override
    public String toString() {
        return "Message (S2C Login ACK) from (" + this.getAddress() + ") CONTENTS: (previousLogins: " + this.previousLogins + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write((byte)this.previousLogins.size());
        for (String string : this.previousLogins) {
            outputSerializer.write255LongString(string);
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        int n = inputSerializer.readByte();
        this.previousLogins = new LinkedList<String>();
        for (int i = 0; i < n; ++i) {
            this.previousLogins.add(inputSerializer.read255LongString());
        }
        if (this.type != Message.MessageType.S2C_LOGIN_ACK) {
            throw new IOException();
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"previousLogins\":[");
        boolean bl = true;
        for (String string : this.previousLogins) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            OutputSerializer.writeJson(stringBuilder, string);
        }
        stringBuilder.append("]");
    }
}

