/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.math.BigInteger;
import marauroa.common.crypto.RSAPublicKey;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CLoginSendKey
extends Message {
    private RSAPublicKey key;

    public MessageS2CLoginSendKey() {
        super(Message.MessageType.S2C_LOGIN_SENDKEY, null);
    }

    public MessageS2CLoginSendKey(Channel channel, RSAPublicKey rSAPublicKey) {
        super(Message.MessageType.S2C_LOGIN_SENDKEY, channel);
        this.key = rSAPublicKey;
    }

    public RSAPublicKey getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return "Message (S2C Login Send key) from (" + this.getAddress() + ") CONTENTS: (n:" + this.key.getN() + "\te:" + this.key.getE() + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.key.getN().toByteArray());
        outputSerializer.write(this.key.getE().toByteArray());
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        BigInteger bigInteger = new BigInteger(inputSerializer.readByteArray());
        BigInteger bigInteger2 = new BigInteger(inputSerializer.readByteArray());
        this.key = new RSAPublicKey(bigInteger, bigInteger2);
        if (this.type != Message.MessageType.S2C_LOGIN_SENDKEY) {
            throw new IOException();
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"n\":\"");
        stringBuilder.append(new BigInteger(this.key.getN().toByteArray()));
        stringBuilder.append("\",\"e\":\"");
        stringBuilder.append(new BigInteger(this.key.getE().toByteArray()));
        stringBuilder.append("\"");
    }
}

