/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Properties;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DatabaseConnectionException;
import marauroa.server.db.adapter.DatabaseAdapter;

public abstract class AbstractDatabaseAdapter
implements DatabaseAdapter {
    private static Logger logger = Log4J.getLogger(AbstractDatabaseAdapter.class);
    protected Connection connection;
    protected LinkedList<Statement> statements = null;
    protected LinkedList<ResultSet> resultSets = null;

    public AbstractDatabaseAdapter(Properties properties) throws DatabaseConnectionException {
        try {
            this.connection = this.createConnection(properties);
        }
        catch (SQLException sQLException) {
            throw new DatabaseConnectionException("Unable to create a connection to: " + properties.get("jdbc_url"), sQLException);
        }
        this.statements = new LinkedList();
        this.resultSets = new LinkedList();
    }

    protected AbstractDatabaseAdapter() throws DatabaseConnectionException {
        this.statements = new LinkedList();
        this.resultSets = new LinkedList();
    }

    protected Connection createConnection(Properties properties) throws SQLException, DatabaseConnectionException {
        try {
            if (properties.get("jdbc_class") != null) {
                Class.forName((String)properties.get("jdbc_class")).newInstance();
            }
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException("Cannot load driver class " + properties.get("jdbc_class"), exception);
        }
        Properties properties2 = new Properties();
        if (properties.get("jdbc_user") != null) {
            properties2.put("user", properties.get("jdbc_user"));
        }
        if (properties.get("jdbc_pwd") != null) {
            properties2.put("password", properties.get("jdbc_pwd"));
        }
        properties2.put("charSet", "UTF-8");
        Connection connection = DriverManager.getConnection((String)properties.get("jdbc_url"), properties2);
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        logger.info("Connected to " + properties.get("jdbc_url") + ": " + databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion() + " with driver " + databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion());
        return connection;
    }

    @Override
    public void commit() throws SQLException {
        this.closeStatements();
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.closeStatements();
        this.connection.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String string) throws SQLException {
        String string2 = this.rewriteSql(string);
        if (string2 == null || string2.equals("")) {
            return -3;
        }
        int n = -2;
        try (Statement statement = this.connection.createStatement();){
            boolean bl = statement.execute(string2);
            if (!bl) {
                n = statement.getUpdateCount();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String string, InputStream ... inputStreamArray) throws SQLException, IOException {
        String string2 = this.rewriteSql(string);
        int n = -2;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(string2);){
            int n2 = 1;
            for (InputStream inputStream : inputStreamArray) {
                preparedStatement.setBinaryStream(n2, inputStream, inputStream.available());
                ++n2;
            }
            n = preparedStatement.executeUpdate();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatch(String string, InputStream ... inputStreamArray) throws SQLException, IOException {
        String string2 = this.rewriteSql(string);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(string2);){
            int n = 1;
            for (InputStream inputStream : inputStreamArray) {
                preparedStatement.setBinaryStream(n, inputStream, inputStream.available());
                preparedStatement.executeUpdate();
            }
        }
    }

    @Override
    public ResultSet query(String string) throws SQLException {
        String string2 = this.rewriteSql(string);
        Statement statement = this.connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(string2);
            this.addToGarbageLists(statement, resultSet);
            return resultSet;
        }
        catch (RuntimeException runtimeException) {
            statement.close();
            throw runtimeException;
        }
        catch (SQLException sQLException) {
            statement.close();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int querySingleCellInt(String string) throws SQLException {
        String string2 = this.rewriteSql(string);
        int n = -1;
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string2);){
            resultSet.next();
            n = resultSet.getInt(1);
        }
        return n;
    }

    void addToGarbageLists(Statement statement, ResultSet resultSet) {
        this.statements.add(statement);
        this.resultSets.add(resultSet);
    }

    private void closeStatements() throws SQLException {
        for (ResultSet autoCloseable : this.resultSets) {
            autoCloseable.close();
        }
        for (Statement statement : this.statements) {
            statement.close();
        }
        this.resultSets.clear();
        this.statements.clear();
    }

    @Override
    public int getLastInsertId(String string, String string2) throws SQLException {
        String string3 = "select LAST_INSERT_ID() as inserted_id";
        return this.querySingleCellInt(string3);
    }

    @Override
    public void close() throws SQLException {
        this.closeStatements();
        this.connection.close();
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        this.statements.add(preparedStatement);
        return preparedStatement;
    }

    @Override
    public boolean doesTableExist(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, string, null);
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    @Override
    public boolean doesColumnExist(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(this.connection.getCatalog(), "%", string, string2);
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    @Override
    public int getColumnLength(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string, string2);
        if (resultSet.next()) {
            return resultSet.getInt("COLUMN_SIZE");
        }
        return -1;
    }

    protected String rewriteSql(String string) throws SQLException {
        return string;
    }

    @Override
    public boolean verifyConnection() {
        try {
            this.query("SELECT 1");
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean isConnectionError(Exception exception) {
        return exception.toString().contains("CommunicationsException") || exception.toString().contains("Query execution was interrupted");
    }
}

