/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.adapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CreateIndexStatementParser {
    private boolean unique;
    private String name;
    private String table;
    private String columns;

    public CreateIndexStatementParser(String string) {
        String string2 = "(?i)create[ ]*((?:unique)?)[ ]+index [ ]*(?:if[ ]+not[ ]+exists )?[ ]*([^ ]+)[ ]*on[ ]+([^ (]+)[ ]*(\\([^)]*\\));?";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Failed to parse CREATE INDEX statement: " + string);
        }
        this.unique = !matcher.group(1).equals("");
        this.name = matcher.group(2);
        this.table = matcher.group(3);
        this.columns = matcher.group(4);
    }

    public String getName() {
        return this.name;
    }

    public String getTable() {
        return this.table;
    }

    public String toSqlWithoutIf() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ");
        if (this.unique) {
            stringBuilder.append("UNIQUE ");
        }
        stringBuilder.append("INDEX ");
        stringBuilder.append(this.name);
        stringBuilder.append(" ON ");
        stringBuilder.append(this.table);
        stringBuilder.append(this.columns);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSqlWithoutIf();
    }
}

