/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.command;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import marauroa.server.db.command.DBCommand;
import marauroa.server.db.command.DBCommandPriority;
import marauroa.server.db.command.ResultHandle;

class DBCommandMetaData
implements Comparable<DBCommandMetaData> {
    private DBCommandPriority priority;
    private DBCommand command;
    private ResultHandle handle;
    private Thread requestingThread;
    private boolean awaitResult;
    private long processedTimestamp = -1L;
    private Locale locale;

    public DBCommandMetaData(DBCommand dBCommand, ResultHandle resultHandle, Thread thread, boolean bl, Locale locale, DBCommandPriority dBCommandPriority) {
        this.command = dBCommand;
        this.handle = resultHandle;
        this.requestingThread = thread;
        this.awaitResult = bl;
        this.locale = locale;
        this.priority = dBCommandPriority;
        dBCommand.setEnqueueTime(new Timestamp(new Date().getTime()));
    }

    public DBCommand getCommand() {
        return this.command;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Thread getRequestingThread() {
        return this.requestingThread;
    }

    public boolean isResultAwaited() {
        return this.awaitResult;
    }

    public long getProcessedTimestamp() {
        return this.processedTimestamp;
    }

    public void setProcessedTimestamp(long l) {
        this.processedTimestamp = l;
    }

    public ResultHandle getResultHandle() {
        return this.handle;
    }

    @Override
    public int compareTo(DBCommandMetaData dBCommandMetaData) {
        int n = this.priority.getPriorityValue() - dBCommandMetaData.priority.getPriorityValue();
        if (n != 0) {
            return n;
        }
        return this.command.getEnqueueTime().compareTo(dBCommandMetaData.command.getEnqueueTime());
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS", Locale.ENGLISH);
        return "[" + this.requestingThread.getName() + ", " + (Object)((Object)this.priority) + ", " + simpleDateFormat.format(this.command.getEnqueueTime()) + ": " + this.command + "]";
    }
}

