/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Random;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.Hash;
import marauroa.common.crypto.Sha512Crypt;
import marauroa.common.i18n.I18N;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.StringChecker;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.container.SecuredLoginInfo;
import marauroa.server.game.db.AccountLinkDAO;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.LoginSeedDAO;

public class AccountDAO {
    private static final Logger logger = Log4J.getLogger(AccountDAO.class);

    protected AccountDAO() {
    }

    @Deprecated
    public void addPlayer(DBTransaction dBTransaction, String string, byte[] byArray, String string2) throws SQLException {
        this.addPlayer(dBTransaction, string, byArray, string2, new Timestamp(new Date().getTime()));
    }

    public void addPlayer(DBTransaction dBTransaction, String string, byte[] byArray, String string2, Timestamp timestamp) throws SQLException {
        try {
            if (!StringChecker.validString(string) || !StringChecker.validString(string2)) {
                throw new SQLException("Invalid string username=(" + string + ") email=(" + string2 + ")");
            }
            String string3 = "insert into account(username, password, status, timedate) values('[username]','[password]', '[status]', '[timedate]')";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            try {
                hashMap.put("status", Configuration.getConfiguration().get("account_creation_status", "active"));
                if (Configuration.getConfiguration().get("password_hash", "sha512").equals("md5")) {
                    hashMap.put("password", Hash.toHexString(byArray));
                } else {
                    String string4 = Configuration.getConfiguration().get("password_pepper", "") + Hash.toHexString(byArray);
                    hashMap.put("password", Sha512Crypt.Sha512_crypt(string4, null, 0));
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
            hashMap.put("timedate", timestamp);
            logger.debug("addPlayer is using query: " + string3);
            dBTransaction.execute(string3, hashMap);
            if (!string2.trim().equals("")) {
                this.changeEmail(dBTransaction, string, string2);
            }
        }
        catch (SQLException sQLException) {
            logger.error("Can't add player \"" + string + "\" to database", sQLException);
            throw sQLException;
        }
    }

    public String generatePlayer(String string) {
        int n = string.length();
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                stringBuilder.append(random.nextInt(10));
                continue;
            }
            if (c == '@') {
                char c2 = (char)(random.nextInt(26) + 97);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void changeEmail(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        try {
            if (!StringChecker.validString(string) || !StringChecker.validString(string2)) {
                throw new SQLException("Invalid string username=(" + string + ") email=(" + string2 + ")");
            }
            String string3 = Hash.toHexString(Hash.random(16));
            int n = this.getDatabasePlayerId(dBTransaction, string);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            hashMap.put("token", string3);
            hashMap.put("email", string2);
            String string4 = "insert into email(player_id, email, token) values ([player_id], '[email]', '[token]')";
            logger.debug("changePassword is using query: " + string4);
            int n2 = dBTransaction.execute(string4, hashMap);
            if (n2 == 1 && Configuration.getConfiguration().has("email_command")) {
                String string5 = Configuration.getConfiguration().get("email_command");
                new ProcessBuilder(string5, Integer.toString(n), string, string3, string2).start();
            }
        }
        catch (IOException iOException) {
            logger.error("Can't change email for player \"" + string + "\"", iOException);
            throw new SQLException(iOException);
        }
        catch (SQLException sQLException) {
            logger.error("Can't change email for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public void changePassword(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        try {
            if (!StringChecker.validString(string)) {
                throw new SQLException("Invalid string username=(" + string + ")");
            }
            String string3 = "update account set password='[password]' where username='[username]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            try {
                if (Configuration.getConfiguration().get("password_hash", "sha512").equals("md5")) {
                    hashMap.put("password", Hash.toHexString(Hash.hash(string2)));
                } else {
                    String string4 = Configuration.getConfiguration().get("password_pepper", "") + Hash.toHexString(Hash.hash(string2));
                    hashMap.put("password", Sha512Crypt.Sha512_crypt(string4, null, 0));
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
            logger.debug("changePassword is using query: " + string3);
            dBTransaction.execute(string3, hashMap);
        }
        catch (SQLException sQLException) {
            logger.error("Can't update password for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public boolean hasPlayer(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            String string2 = "select count(*) as amount from account where username = '[username]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            logger.debug("hasPlayer is using query: " + string2);
            int n = dBTransaction.querySingleCellInt(string2, hashMap);
            return n > 0;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public void setAccountStatus(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        try {
            String string3 = "update account set status='[status]' where username = '[username]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            hashMap.put("status", string2);
            logger.debug("setAccountStatus is executing query " + string3);
            dBTransaction.execute(string3, hashMap);
        }
        catch (SQLException sQLException) {
            logger.error("Can't update account status of player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public String getAccountStatus(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            String string2 = "SELECT account.status As status, accountban.reason As reason FROM account LEFT JOIN accountban ON (account.id=accountban.player_id AND (accountban.expire > CURRENT_TIMESTAMP OR accountban.expire IS NULL)) WHERE username='[username]' order by ifnull(expire,'9999-12-31') desc limit 1 ";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            logger.debug("getAccountStatus is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            String string3 = null;
            if (resultSet.next() && (string3 = resultSet.getString("status")).equals("active") && resultSet.getString("reason") != null) {
                string3 = "banned";
            }
            resultSet.close();
            return string3;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public String getAccountBanMessage(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            String string2 = "SELECT account.status As status, accountban.reason As reason, accountban.expire As expire FROM account LEFT JOIN accountban ON (account.id=accountban.player_id AND (accountban.expire > CURRENT_TIMESTAMP OR accountban.expire IS NULL)) WHERE username='[username]' order by COALESCE(expire,'9999-12-31') desc limit 1 ";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            logger.debug("getAccountStatus is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            String string3 = null;
            if (resultSet.next()) {
                String string4 = resultSet.getString("status");
                String string5 = resultSet.getString("reason");
                String string6 = resultSet.getString("expire");
                if (string5 != null) {
                    string3 = string6 != null ? I18N.translate("Twoje konto zosta\u0142o zawieszone na %1$s wg czasu serwera.", string6) + "\r\n" : I18N.translate("Twoje konto zosta\u0142o zablokowane.", new Object[0]) + "\r\n";
                    string3 = string3 + I18N.translate("Powodem by\u0142o: %1$s", string5) + "\r\n";
                } else if ("banned".equals(string4)) {
                    string3 = I18N.translate("Twoje konto zosta\u0142o zablokowane. Skontaktuj si\u0119 ze wsparciem.", new Object[0]) + "\r\n";
                } else if ("inactive".equals(string4)) {
                    string3 = I18N.translate("Twoje konto jest jeszcze nieaktywne.\nPotwierd\u017a rejestracj\u0119 konta przez klikni\u0119cie na odno\u015bnik znajduj\u0105cy si\u0119 w mailu, kt\u00f3ry zosta\u0142 wys\u0142any na adres podany podczas rejestracji. W razie problem\u00f3w skontaktuj si\u0119 ze wsparciem.", new Object[0]) + "\r\n";
                } else if ("merged".equals(string4)) {
                    string3 = I18N.translate("Twoje konto zosta\u0142o po\u0142\u0105czone z innym.\nZaloguj si\u0119 na to konto lub skontaktuj si\u0119 ze wsparciem.", new Object[0]) + "\r\n";
                }
                if (!(string5 == null && "active".equals(string4) || "merged".equals(string4))) {
                    try {
                        Configuration configuration = Configuration.getConfiguration();
                        if (configuration.has("server_abuseContact")) {
                            string3 = string3 + configuration.get("server_abuseContact");
                        }
                    }
                    catch (IOException iOException) {
                        logger.error(iOException, iOException);
                    }
                }
            }
            resultSet.close();
            return string3;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public String getEmail(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            String string2 = "select email.email from account, email where username = '[username]' AND account.id=email.player_id";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            logger.debug("getEmail is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            String string3 = null;
            if (resultSet.next()) {
                string3 = resultSet.getString("email");
            }
            resultSet.close();
            return string3;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public int getDatabasePlayerId(DBTransaction dBTransaction, String string) throws SQLException {
        String string2 = "select id from account where username = '[username]'";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("username", string);
        logger.debug("getDatabasePlayerId is executing query " + string2);
        ResultSet resultSet = dBTransaction.query(string2, hashMap);
        int n = -1;
        if (resultSet.next()) {
            n = resultSet.getInt("id");
        }
        resultSet.close();
        return n;
    }

    public boolean verify(DBTransaction dBTransaction, SecuredLoginInfo securedLoginInfo) throws SQLException {
        boolean bl;
        Object object;
        if (securedLoginInfo.seed != null) {
            object = DAORegister.get().get(LoginSeedDAO.class);
            Boolean bl2 = ((LoginSeedDAO)object).verifySeed(dBTransaction, securedLoginInfo.username, securedLoginInfo.seed);
            if (bl2 == null) {
                securedLoginInfo.reason = MessageS2CLoginNACK.Reasons.SEED_WRONG;
                return false;
            }
            ((LoginSeedDAO)object).useSeed(dBTransaction, securedLoginInfo.seed);
            if (bl2.booleanValue()) {
                return true;
            }
        }
        if (securedLoginInfo.token != null && securedLoginInfo.tokenType != null && (bl = ((AccountLinkDAO)(object = DAORegister.get().get(AccountLinkDAO.class))).verifyPermanentToken(dBTransaction, securedLoginInfo))) {
            return true;
        }
        object = securedLoginInfo.getDecryptedPasswordHash();
        if (object == null) {
            return false;
        }
        boolean bl3 = this.verifyUsingDB(dBTransaction, securedLoginInfo.username, (byte[])object);
        return bl3;
    }

    public boolean verifyPassword(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        return this.verifyUsingDB(dBTransaction, string, Hash.hash(string2));
    }

    private boolean verifyUsingDB(DBTransaction dBTransaction, String string, byte[] byArray) throws SQLException {
        try {
            String string2 = "select username, password from account where username = '[username]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            logger.debug("verifyAccount is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            if (!resultSet.next()) {
                resultSet.close();
                return false;
            }
            String string3 = resultSet.getString("username");
            if (!string3.equalsIgnoreCase(string)) {
                logger.warn("Username \"" + string + "\" is not the same that stored username \"" + string3 + "\"");
                resultSet.close();
                return false;
            }
            String string4 = resultSet.getString("password");
            resultSet.close();
            boolean bl = false;
            if (string4 == null) {
                return bl;
            }
            if (string4.startsWith("$6$")) {
                String string5 = Configuration.getConfiguration().get("password_pepper", "");
                bl = Sha512Crypt.verifyPassword(string5 + Hash.toHexString(byArray), string4);
                if (!bl) {
                    bl = Sha512Crypt.verifyPassword(string5 + Hash.toHexString(byArray), string4);
                }
            } else {
                String string6 = Hash.toHexString(byArray);
                bl = string6.equalsIgnoreCase(string4);
                if (!bl) {
                    string6 = Hash.toHexString(Hash.hash(byArray));
                    bl = string6.equalsIgnoreCase(string4);
                }
            }
            return bl;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            logger.error("Can't query for player \"" + string + "\"", iOException);
            return false;
        }
    }

    public boolean removePlayer(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            CharacterDAO characterDAO = DAORegister.get().get(CharacterDAO.class);
            for (String object2 : characterDAO.getCharacters(dBTransaction, string)) {
                characterDAO.removeCharacter(dBTransaction, string, object2);
            }
            String string2 = "delete from account where username='[username]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            logger.debug("removePlayer is using query: " + (String)string2);
            dBTransaction.execute(string2, hashMap);
            return true;
        }
        catch (SQLException sQLException) {
            logger.error("Can't remove player\"" + string + "\" from database", sQLException);
            throw sQLException;
        }
    }

    public boolean isAccountCreationLimitReached(DBTransaction dBTransaction, String string) throws SQLException, IOException {
        Configuration configuration = Configuration.getConfiguration();
        String string2 = "," + configuration.get("ip_whitelist", "127.0.0.1") + ",";
        if (string2.indexOf("," + string + ",") > -1) {
            return false;
        }
        String string3 = "SELECT count(DISTINCT username) FROM account, loginEvent WHERE account.id=loginEvent.player_id AND address='[address]' AND account.timedate>'[timestamp]'";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("address", string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(13, -1 * configuration.getInt("account_creation_counting_time", 3600));
        hashMap.put("timestamp", new Timestamp(gregorianCalendar.getTimeInMillis()).toString());
        int n = dBTransaction.querySingleCellInt(string3, hashMap);
        return n > configuration.getInt("account_creation_limit", 5);
    }

    public void addBan(DBTransaction dBTransaction, String string, String string2, Timestamp timestamp) throws SQLException {
        try {
            int n = this.getDatabasePlayerId(dBTransaction, string);
            String string3 = "'[expire]'";
            if (timestamp == null) {
                string3 = "null";
            }
            String string4 = "insert into accountban(player_id, reason, expire) values('[player_id]','[reason]', " + string3 + ")";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            hashMap.put("reason", string2);
            hashMap.put("expire", timestamp);
            logger.debug("addBan is using query: " + string4);
            dBTransaction.execute(string4, hashMap);
            if ("null".equals(string3)) {
                this.setAccountStatus(dBTransaction, string, "banned");
            }
        }
        catch (SQLException sQLException) {
            logger.error("Can't insert ban for player \"" + string + "\" with expire of " + timestamp + " into database", sQLException);
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addPlayer(String string, byte[] byArray, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.addPlayer(dBTransaction, string, byArray, string2, new Timestamp(new Date().getTime()));
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void changeEmail(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.changeEmail(dBTransaction, string, string2);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void changePassword(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.changePassword(dBTransaction, string, string2);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean hasPlayer(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.hasPlayer(dBTransaction, string);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setAccountStatus(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.setAccountStatus(dBTransaction, string, string2);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getAccountStatus(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            String string2;
            String string3 = string2 = this.getAccountStatus(dBTransaction, string);
            return string3;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getAccountBanMessage(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            String string2;
            String string3 = string2 = this.getAccountBanMessage(dBTransaction, string);
            return string3;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getEmail(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            String string2;
            String string3 = string2 = this.getEmail(dBTransaction, string);
            return string3;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getDatabasePlayerId(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            int n;
            int n2 = n = this.getDatabasePlayerId(dBTransaction, string);
            return n2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean verify(SecuredLoginInfo securedLoginInfo) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.verify(dBTransaction, securedLoginInfo);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean verifyPassword(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl = this.verifyPassword(dBTransaction, string, string2);
            return bl;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean removePlayer(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.removePlayer(dBTransaction, string);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isAccountCreationLimitReached(String string) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.isAccountCreationLimitReached(dBTransaction, string);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addBan(String string, String string2, Timestamp timestamp) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.addBan(dBTransaction, string, string2, timestamp);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }
}

