/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.rp.GameEvent;

public class GameEventDAO {
    private static final Logger logger = Log4J.getLogger(GameEventDAO.class);

    protected GameEventDAO() {
    }

    @Deprecated
    public void addGameEvent(DBTransaction dBTransaction, String string, String string2, String ... stringArray) throws SQLException {
        this.addGameEvent(dBTransaction, new Timestamp(new Date().getTime()), string, string2, stringArray);
    }

    public void addGameEvent(DBTransaction dBTransaction, Timestamp timestamp, String string, String string2, String ... stringArray) throws SQLException {
        String string3 = stringArray.length > 0 ? stringArray[0] : "";
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 1) {
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(" ");
            }
        }
        String string4 = stringBuilder.toString();
        String string5 = "insert into gameEvents(source, event, param1, param2, timedate) values('[source]', '[event]', '[param1]', '[param2]', '[timedate');";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("source", string);
        hashMap.put("event", string2);
        hashMap.put("param1", string3 == null ? null : string3.substring(0, Math.min(127, string3.length())));
        hashMap.put("param2", string4.substring(0, Math.min(255, string4.length())));
        hashMap.put("timedate", timestamp);
        dBTransaction.execute(string5, hashMap);
    }

    public void addGameEvents(DBTransaction dBTransaction, List<GameEvent> list) throws SQLException {
        String string = "INSERT INTO gameEvents(source, event, timedate, param1, param2) values(?, ?, ?, ?, ?);";
        PreparedStatement preparedStatement = dBTransaction.prepareStatement(string, null);
        logger.debug("ActionsDAO is executing query " + string);
        for (GameEvent gameEvent : list) {
            String[] stringArray = gameEvent.getParams();
            String string2 = stringArray.length > 0 ? stringArray[0] : "";
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray.length > 1) {
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append(" ");
                }
            }
            String string3 = stringBuilder.toString();
            preparedStatement.setString(1, gameEvent.getSource());
            preparedStatement.setString(2, gameEvent.getEvent());
            preparedStatement.setTimestamp(3, gameEvent.getTimestamp());
            preparedStatement.setString(4, string2 == null ? null : string2.substring(0, Math.min(127, string2.length())));
            preparedStatement.setString(5, string3.substring(0, Math.min(255, string3.length())));
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    @Deprecated
    public void addGameEvent(String string, String string2, String ... stringArray) {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.addGameEvent(dBTransaction, string, string2, stringArray);
            TransactionPool.get().commit(dBTransaction);
        }
        catch (SQLException sQLException) {
            logger.error("Error adding game event: " + string2, sQLException);
            TransactionPool.get().rollback(dBTransaction);
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error adding game event: " + string2, runtimeException);
            TransactionPool.get().rollback(dBTransaction);
        }
    }
}

