/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.dbcommand;

import java.io.IOException;
import java.sql.SQLException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.Channel;
import marauroa.server.db.DBTransaction;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.dbcommand.LoadCharacterCommand;
import marauroa.server.game.messagehandler.DelayedEventHandler;

public class LoadActiveCharacterCommand
extends LoadCharacterCommand {
    private static Logger logger = Log4J.getLogger(LoadActiveCharacterCommand.class);

    public LoadActiveCharacterCommand(String string, String string2) {
        super(string, string2);
    }

    public LoadActiveCharacterCommand(String string, String string2, DelayedEventHandler delayedEventHandler, int n, Channel channel, int n2) {
        super(string, string2, delayedEventHandler, n, channel, n2);
    }

    @Override
    public void execute(DBTransaction dBTransaction) throws SQLException, IOException {
        if (DAORegister.get().get(CharacterDAO.class).hasActiveCharacter(dBTransaction, this.getUsername(), this.getCharacterName())) {
            super.execute(dBTransaction);
        } else {
            logger.warn("Trying to load a non active character. username: " + this.getUsername() + " charactername: " + this.getCharacterName());
        }
    }
}

