/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.dbcommand;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import marauroa.server.db.DBTransaction;
import marauroa.server.game.db.BanListDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.dbcommand.DBCommandWithCallback;
import marauroa.server.game.messagehandler.DelayedEventHandler;
import marauroa.server.net.validator.InetAddressMask;

public class LoadBanListCommand
extends DBCommandWithCallback {
    private List<InetAddressMask> permanentBans;

    public LoadBanListCommand(DelayedEventHandler delayedEventHandler) {
        super(delayedEventHandler, 0, null, 0);
    }

    @Override
    public void execute(DBTransaction dBTransaction) throws SQLException, IOException {
        this.permanentBans = DAORegister.get().get(BanListDAO.class).getBannedAddresses(dBTransaction);
    }

    public List<InetAddressMask> getPermanentBans() {
        return new LinkedList<InetAddressMask>(this.permanentBans);
    }

    public String toString() {
        return "LoadBanListCommand";
    }
}

