/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.AccountResult;
import marauroa.common.game.Result;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SCreateAccountWithToken;
import marauroa.common.net.message.MessageS2CCreateAccountACK;
import marauroa.common.net.message.MessageS2CCreateAccountNACK;
import marauroa.server.game.messagehandler.MessageHandler;

class CreateAccountWithTokenHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(CreateAccountWithTokenHandler.class);

    CreateAccountWithTokenHandler() {
    }

    @Override
    public void process(Message message) {
        try {
            Result result;
            Object object;
            if (this.rpMan == null || message == null || message.getAddress() == null) {
                logger.error("Unexpected null value in CreateAccountWithTokenHandler.process: rpMan=" + this.rpMan + " msg=" + message);
                if (message != null) {
                    logger.error("address=" + message.getAddress());
                }
                return;
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (message instanceof MessageC2SCreateAccountWithToken) {
                object = (MessageC2SCreateAccountWithToken)message;
                string = ((MessageC2SCreateAccountWithToken)object).getUsername();
                string2 = ((MessageC2SCreateAccountWithToken)object).getTokenType();
                string3 = ((MessageC2SCreateAccountWithToken)object).getToken();
                string4 = ((Message)object).getAddress().getHostAddress();
            }
            if ((result = ((AccountResult)(object = this.rpMan.createAccountWithToken(string, string2, string3, string4))).getResult()) == Result.OK_CREATED) {
                logger.debug("Account (" + string + ") created.");
                MessageS2CCreateAccountACK messageS2CCreateAccountACK = new MessageS2CCreateAccountACK(message.getChannel(), ((AccountResult)object).getUsername());
                messageS2CCreateAccountACK.setProtocolVersion(message.getProtocolVersion());
                this.netMan.sendMessage(messageS2CCreateAccountACK);
            } else {
                MessageS2CCreateAccountNACK messageS2CCreateAccountNACK = new MessageS2CCreateAccountNACK(message.getChannel(), string, result);
                messageS2CCreateAccountNACK.setProtocolVersion(message.getProtocolVersion());
                this.netMan.sendMessage(messageS2CCreateAccountNACK);
            }
        }
        catch (Exception exception) {
            logger.error("Unable to create an account", exception);
        }
    }
}

