/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SLoginRequestKey;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.common.net.message.MessageS2CLoginSendKey;
import marauroa.server.game.messagehandler.MessageHandler;

class LoginRequestKeyHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(LoginRequestKeyHandler.class);

    LoginRequestKeyHandler() {
    }

    @Override
    public void process(Message message) {
        MessageC2SLoginRequestKey messageC2SLoginRequestKey = (MessageC2SLoginRequestKey)message;
        if (messageC2SLoginRequestKey.skipGameVersionCheck() || this.rpMan.checkGameVersion(messageC2SLoginRequestKey.getGame(), messageC2SLoginRequestKey.getVersion())) {
            MessageS2CLoginSendKey messageS2CLoginSendKey = new MessageS2CLoginSendKey(message.getChannel(), this.key);
            messageS2CLoginSendKey.setClientID(message.getClientID());
            messageS2CLoginSendKey.setProtocolVersion(message.getProtocolVersion());
            this.netMan.sendMessage(messageS2CLoginSendKey);
        } else {
            logger.debug("Client is running an incompatible game version. Client(" + message.getAddress().toString() + ") can't login");
            MessageS2CLoginNACK messageS2CLoginNACK = new MessageS2CLoginNACK(message.getChannel(), MessageS2CLoginNACK.Reasons.GAME_MISMATCH);
            messageS2CLoginNACK.setProtocolVersion(message.getProtocolVersion());
            this.netMan.sendMessage(messageS2CLoginNACK);
        }
    }
}

