/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import java.util.HashMap;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.RSAKey;
import marauroa.common.i18n.I18N;
import marauroa.common.net.message.Message;
import marauroa.server.game.Statistics;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.messagehandler.ActionHandler;
import marauroa.server.game.messagehandler.ChooseCharacterHandler;
import marauroa.server.game.messagehandler.CreateAccountHandler;
import marauroa.server.game.messagehandler.CreateAccountWithTokenHandler;
import marauroa.server.game.messagehandler.CreateCharacterHandler;
import marauroa.server.game.messagehandler.KeepAliveHandler;
import marauroa.server.game.messagehandler.LoginRequestKeyHandler;
import marauroa.server.game.messagehandler.LoginSendPromiseHandler;
import marauroa.server.game.messagehandler.LogoutHandler;
import marauroa.server.game.messagehandler.MessageHandler;
import marauroa.server.game.messagehandler.OutOfSyncHandler;
import marauroa.server.game.messagehandler.SecuredLoginHandler;
import marauroa.server.game.messagehandler.TransferACKHandler;
import marauroa.server.game.messagehandler.UnkownMessageHandler;
import marauroa.server.game.messagehandler.UpdateResponseHandler;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.net.INetworkServerManager;

public class MessageDispatcher {
    private static final Logger logger = Log4J.getLogger(MessageDispatcher.class);
    private final Map<Message.MessageType, MessageHandler> handlers = new HashMap<Message.MessageType, MessageHandler>();

    private void initMap() {
        this.handlers.put(Message.MessageType.C2S_LOGIN_REQUESTKEY, new LoginRequestKeyHandler());
        this.handlers.put(Message.MessageType.C2S_LOGIN_SENDPROMISE, new LoginSendPromiseHandler());
        this.handlers.put(Message.MessageType.C2S_LOGIN_SENDNONCENAMEANDPASSWORD, new SecuredLoginHandler());
        this.handlers.put(Message.MessageType.C2S_LOGIN_SENDNONCENAMEPASSWORDANDSEED, new SecuredLoginHandler());
        this.handlers.put(Message.MessageType.C2S_LOGIN_SENDUSERNAMEANDPASSWORD, new SecuredLoginHandler());
        this.handlers.put(Message.MessageType.C2S_LOGIN_WITH_TOKEN, new SecuredLoginHandler());
        this.handlers.put(Message.MessageType.C2S_CHOOSECHARACTER, new ChooseCharacterHandler());
        this.handlers.put(Message.MessageType.C2S_LOGOUT, new LogoutHandler());
        this.handlers.put(Message.MessageType.C2S_ACTION, new ActionHandler());
        this.handlers.put(Message.MessageType.C2S_OUTOFSYNC, new OutOfSyncHandler());
        this.handlers.put(Message.MessageType.C2S_KEEPALIVE, new KeepAliveHandler());
        this.handlers.put(Message.MessageType.C2S_TRANSFER_ACK, new TransferACKHandler());
        this.handlers.put(Message.MessageType.C2S_CREATEACCOUNT, new CreateAccountHandler());
        this.handlers.put(Message.MessageType.C2S_CREATE_ACCOUNT_WITH_TOKEN, new CreateAccountWithTokenHandler());
        this.handlers.put(Message.MessageType.C2S_CREATECHARACTER, new CreateCharacterHandler());
        this.handlers.put(Message.MessageType.P2S_CREATEACCOUNT, new CreateAccountHandler());
        this.handlers.put(Message.MessageType.P2S_CREATECHARACTER, new CreateCharacterHandler());
        this.handlers.put(Message.MessageType.C2S_UPDATE_RESPONSE, new UpdateResponseHandler());
    }

    public MessageDispatcher() {
        this.initMap();
    }

    public void init(INetworkServerManager iNetworkServerManager, RPServerManager rPServerManager, PlayerEntryContainer playerEntryContainer, Statistics statistics, RSAKey rSAKey) {
        for (MessageHandler messageHandler : this.handlers.values()) {
            messageHandler.init(iNetworkServerManager, rPServerManager, playerEntryContainer, statistics, rSAKey);
        }
    }

    public void dispatchMessage(Message message) {
        logger.debug("Processing " + (Object)((Object)message.getType()));
        MessageHandler messageHandler = this.findMessageHandler(message);
        this.setThreadLanguage(message);
        try {
            messageHandler.process(message);
        }
        finally {
            I18N.resetThreadLocale();
        }
    }

    private MessageHandler findMessageHandler(Message message) {
        MessageHandler messageHandler = this.handlers.get((Object)message.getType());
        if (messageHandler == null) {
            messageHandler = new UnkownMessageHandler();
        }
        return messageHandler;
    }

    private void setThreadLanguage(Message message) {
        int n = message.getClientID();
        PlayerEntry playerEntry = PlayerEntryContainer.getContainer().get(n);
        if (playerEntry != null) {
            I18N.setThreadLocale(playerEntry.locale);
        }
    }
}

