/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.Hash;
import marauroa.common.crypto.SymmetricKey;
import marauroa.common.net.Channel;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SLoginSendNonceNameAndPassword;
import marauroa.common.net.message.MessageC2SLoginSendNonceNamePasswordAndSeed;
import marauroa.common.net.message.MessageC2SLoginSendUsernameAndPassword;
import marauroa.common.net.message.MessageC2SLoginWithToken;
import marauroa.common.net.message.MessageS2CLoginACK;
import marauroa.common.net.message.MessageS2CLoginMessageNACK;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.common.net.message.MessageS2CServerInfo;
import marauroa.server.auth.AuthenticationManager;
import marauroa.server.db.command.DBCommandPriority;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.container.SecuredLoginInfo;
import marauroa.server.game.dbcommand.LoadAllActiveCharactersCommand;
import marauroa.server.game.dbcommand.LoginCommand;
import marauroa.server.game.messagehandler.DelayedEventHandler;
import marauroa.server.game.messagehandler.MessageHandler;
import marauroa.server.game.messagehandler.SendCharacterListHandler;
import marauroa.server.game.rp.RPServerManager;

class SecuredLoginHandler
extends MessageHandler
implements DelayedEventHandler {
    private static final Logger logger = Log4J.getLogger(SecuredLoginHandler.class);
    private AuthenticationManager authMan;

    public SecuredLoginHandler() {
        try {
            Configuration configuration = Configuration.getConfiguration();
            Class<?> clazz = Class.forName(configuration.get("authentication", "marauroa.server.auth.DatabaseAuthenticationManager"));
            this.authMan = (AuthenticationManager)clazz.newInstance();
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            logger.error(reflectiveOperationException, reflectiveOperationException);
        }
    }

    @Override
    public void process(Message message) {
        int n = message.getClientID();
        PlayerEntry playerEntry = this.playerContainer.get(n);
        if (!this.isValidEvent(message, playerEntry, ClientState.CONNECTION_ACCEPTED)) {
            return;
        }
        SecuredLoginInfo securedLoginInfo = this.fillLoginInfo(message, playerEntry);
        if (securedLoginInfo.isUsingSecureChannel() && Hash.compare(Hash.hash(securedLoginInfo.clientNonce), securedLoginInfo.clientNonceHash) != 0) {
            logger.warn("Different hashs for client Nonce");
            return;
        }
        this.authMan.verify(securedLoginInfo, this, playerEntry.clientid, message.getChannel(), message.getProtocolVersion());
    }

    private void completeLogin(Channel channel, int n, int n2, SecuredLoginInfo securedLoginInfo, List<String> list) {
        PlayerEntry playerEntry = PlayerEntryContainer.getContainer().get(n);
        logger.debug("Correct username/password");
        if (playerEntry == null) {
            logger.warn("Did not find PlayerEntry in completeLogin, timeout? " + securedLoginInfo);
            return;
        }
        playerEntry.username = securedLoginInfo.username;
        playerEntry.loginInformations = null;
        this.stats.add("Players login", 1);
        MessageS2CLoginACK messageS2CLoginACK = new MessageS2CLoginACK(channel, list);
        messageS2CLoginACK.setClientID(n);
        messageS2CLoginACK.setProtocolVersion(n2);
        this.netMan.sendMessage(messageS2CLoginACK);
        MessageS2CServerInfo messageS2CServerInfo = new MessageS2CServerInfo(channel, ServerInfo.get());
        messageS2CServerInfo.setClientID(n);
        messageS2CServerInfo.setProtocolVersion(n2);
        this.netMan.sendMessage(messageS2CServerInfo);
        LoadAllActiveCharactersCommand loadAllActiveCharactersCommand = new LoadAllActiveCharactersCommand(playerEntry.username, new SendCharacterListHandler(this.netMan, n2), n, channel, n2);
        DBCommandQueue.get().enqueue(loadAllActiveCharactersCommand, DBCommandPriority.CRITICAL);
        playerEntry.state = ClientState.LOGIN_COMPLETE;
    }

    private SecuredLoginInfo fillLoginInfo(Message message, PlayerEntry playerEntry) {
        SecuredLoginInfo securedLoginInfo = playerEntry.loginInformations;
        if (message instanceof MessageC2SLoginSendNonceNameAndPassword) {
            MessageC2SLoginSendNonceNameAndPassword messageC2SLoginSendNonceNameAndPassword = (MessageC2SLoginSendNonceNameAndPassword)message;
            securedLoginInfo.clientNonce = messageC2SLoginSendNonceNameAndPassword.getHash();
            securedLoginInfo.username = messageC2SLoginSendNonceNameAndPassword.getUsername();
            securedLoginInfo.password = messageC2SLoginSendNonceNameAndPassword.getPassword();
        } else if (message instanceof MessageC2SLoginSendNonceNamePasswordAndSeed) {
            MessageC2SLoginSendNonceNamePasswordAndSeed messageC2SLoginSendNonceNamePasswordAndSeed = (MessageC2SLoginSendNonceNamePasswordAndSeed)message;
            securedLoginInfo.clientNonce = messageC2SLoginSendNonceNamePasswordAndSeed.getHash();
            securedLoginInfo.username = messageC2SLoginSendNonceNamePasswordAndSeed.getUsername();
            securedLoginInfo.password = messageC2SLoginSendNonceNamePasswordAndSeed.getPassword();
            securedLoginInfo.seed = this.decode(securedLoginInfo, messageC2SLoginSendNonceNamePasswordAndSeed.getSeed());
        } else if (message instanceof MessageC2SLoginWithToken) {
            MessageC2SLoginWithToken messageC2SLoginWithToken = (MessageC2SLoginWithToken)message;
            securedLoginInfo.clientNonce = messageC2SLoginWithToken.getNonce();
            securedLoginInfo.username = messageC2SLoginWithToken.getUsername();
            securedLoginInfo.tokenType = messageC2SLoginWithToken.getTokenType();
            securedLoginInfo.token = this.decodeToken(securedLoginInfo, messageC2SLoginWithToken);
        } else {
            MessageC2SLoginSendUsernameAndPassword messageC2SLoginSendUsernameAndPassword = (MessageC2SLoginSendUsernameAndPassword)message;
            playerEntry.loginInformations = securedLoginInfo = new SecuredLoginInfo(playerEntry.getAddress());
            securedLoginInfo.username = messageC2SLoginSendUsernameAndPassword.getUsername();
            securedLoginInfo.password = messageC2SLoginSendUsernameAndPassword.getPassword();
            securedLoginInfo.usingSecureChannel = false;
        }
        return securedLoginInfo;
    }

    private String decode(SecuredLoginInfo securedLoginInfo, byte[] byArray) {
        byte[] byArray2 = securedLoginInfo.key.decodeByteArray(byArray);
        byte[] byArray3 = Hash.xor(securedLoginInfo.clientNonce, securedLoginInfo.serverNonce);
        if (byArray3 == null) {
            logger.debug("B2 is null");
            return null;
        }
        byte[] byArray4 = Hash.xor(byArray2, byArray3);
        try {
            return new String(byArray4, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException, unsupportedEncodingException);
            return null;
        }
    }

    private String decodeToken(SecuredLoginInfo securedLoginInfo, MessageC2SLoginWithToken messageC2SLoginWithToken) {
        try {
            byte[] byArray = messageC2SLoginWithToken.getEncryptedSessionKey();
            byte[] byArray2 = securedLoginInfo.key.decodeByteArray(byArray);
            byte[] byArray3 = Hash.xor(securedLoginInfo.clientNonce, securedLoginInfo.serverNonce);
            byte[] byArray4 = Hash.xor(byArray2, byArray3);
            SymmetricKey symmetricKey = new SymmetricKey(byArray4);
            byte[] byArray5 = messageC2SLoginWithToken.getInitVector();
            byte[] byArray6 = symmetricKey.decrypt(byArray5, messageC2SLoginWithToken.getEncryptedToken());
            return new String(byArray6, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException, unsupportedEncodingException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.error(generalSecurityException, generalSecurityException);
        }
        return null;
    }

    @Override
    public void handleDelayedEvent(RPServerManager rPServerManager, Object object) {
        try {
            Object object2;
            Configuration configuration;
            int n;
            LoginCommand loginCommand = (LoginCommand)object;
            SecuredLoginInfo securedLoginInfo = loginCommand.getInfo();
            if (loginCommand.getFailReason() == MessageS2CLoginNACK.Reasons.TOO_MANY_TRIES) {
                logger.debug("Blocked account for player " + securedLoginInfo.username + " and/or address " + securedLoginInfo.address);
                MessageS2CLoginNACK messageS2CLoginNACK = new MessageS2CLoginNACK(loginCommand.getChannel(), MessageS2CLoginNACK.Reasons.TOO_MANY_TRIES);
                messageS2CLoginNACK.setProtocolVersion(loginCommand.getProtocolVersion());
                this.netMan.sendMessage(messageS2CLoginNACK);
                this.netMan.disconnectClient(loginCommand.getChannel());
                return;
            }
            if (loginCommand.getFailReason() != null) {
                logger.debug("Incorrect username/password for player " + securedLoginInfo.username);
                this.stats.add("Players invalid login", 1);
                if (securedLoginInfo.reason == null) {
                    securedLoginInfo.reason = MessageS2CLoginNACK.Reasons.USERNAME_WRONG;
                }
                MessageS2CLoginNACK messageS2CLoginNACK = new MessageS2CLoginNACK(loginCommand.getChannel(), securedLoginInfo.reason);
                messageS2CLoginNACK.setProtocolVersion(loginCommand.getProtocolVersion());
                this.netMan.sendMessage(messageS2CLoginNACK);
                this.playerContainer.remove(loginCommand.getClientid());
                return;
            }
            if (loginCommand.getFailMessage() != null) {
                logger.info("Banned/Inactive account for player " + securedLoginInfo.username + ": " + loginCommand.getFailMessage());
                MessageS2CLoginMessageNACK messageS2CLoginMessageNACK = new MessageS2CLoginMessageNACK(loginCommand.getChannel(), loginCommand.getFailMessage());
                messageS2CLoginMessageNACK.setProtocolVersion(loginCommand.getProtocolVersion());
                this.netMan.sendMessage(messageS2CLoginMessageNACK);
                this.netMan.disconnectClient(loginCommand.getChannel());
                return;
            }
            int n2 = securedLoginInfo.countConnectionsFromSameIPAddress(this.playerContainer);
            if (n2 > (n = (configuration = Configuration.getConfiguration()).getInt("parallel_connection_limit", 10)) && ((String)(object2 = "," + configuration.get("ip_whitelist", "127.0.0.1") + ",")).indexOf("," + securedLoginInfo.address + ",") < 0) {
                logger.info("to many parallel connections from " + securedLoginInfo.address + " rejecting login of " + securedLoginInfo.username);
                MessageS2CLoginMessageNACK messageS2CLoginMessageNACK = new MessageS2CLoginMessageNACK(loginCommand.getChannel(), "There are too many connections from your ip-address.\nPlease contact /support, if you are at a conference or something similar.");
                messageS2CLoginMessageNACK.setProtocolVersion(loginCommand.getProtocolVersion());
                this.netMan.sendMessage(messageS2CLoginMessageNACK);
                this.netMan.disconnectClient(loginCommand.getChannel());
                return;
            }
            object2 = loginCommand.getPreviousLogins();
            this.completeLogin(loginCommand.getChannel(), loginCommand.getClientid(), loginCommand.getProtocolVersion(), securedLoginInfo, (List<String>)object2);
        }
        catch (IOException iOException) {
            logger.error("error while processing SecuredLoginEvent: " + object, iOException);
        }
        catch (RuntimeException runtimeException) {
            logger.error("error while processing SecuredLoginEvent: " + object, runtimeException);
        }
    }

    private static class ServerInfo {
        private static org.apache.log4j.Logger infoLogger = org.apache.log4j.Logger.getLogger(ServerInfo.class);
        private static Configuration config;

        private ServerInfo() {
        }

        public static String[] get() {
            String[] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration<?> enumeration = config.propertyNames();
            while (enumeration.hasMoreElements()) {
                stringArray = String.valueOf(enumeration.nextElement());
                if (!stringArray.startsWith("server_")) continue;
                arrayList.add(config.get((String)stringArray));
            }
            stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }

        static {
            try {
                config = Configuration.getConfiguration();
                config.get("server_typeGame");
                config.get("server_name");
                config.get("server_version");
                config.get("server_contact");
            }
            catch (Exception exception) {
                infoLogger.error((Object)"ERROR: Unable to load Server info", (Throwable)exception);
            }
        }
    }
}

