/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import java.util.Map;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.message.MessageS2CCharacterList;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.dbcommand.LoadAllActiveCharactersCommand;
import marauroa.server.game.messagehandler.DelayedEventHandler;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.net.INetworkServerManager;

public class SendCharacterListHandler
implements DelayedEventHandler {
    private final INetworkServerManager netMan;
    private final int protocolVersion;

    public SendCharacterListHandler(INetworkServerManager iNetworkServerManager, int n) {
        this.netMan = iNetworkServerManager;
        this.protocolVersion = n;
    }

    @Override
    public void handleDelayedEvent(RPServerManager rPServerManager, Object object) {
        LoadAllActiveCharactersCommand loadAllActiveCharactersCommand = (LoadAllActiveCharactersCommand)object;
        Map<String, RPObject> map = loadAllActiveCharactersCommand.getCharacters();
        int n = loadAllActiveCharactersCommand.getClientid();
        Channel channel = loadAllActiveCharactersCommand.getChannel();
        PlayerEntry playerEntry = PlayerEntryContainer.getContainer().get(channel);
        if (playerEntry != null) {
            playerEntry.characterCounter = map.keySet().size();
            MessageS2CCharacterList messageS2CCharacterList = new MessageS2CCharacterList(channel, map);
            messageS2CCharacterList.setProtocolVersion(this.protocolVersion);
            messageS2CCharacterList.setClientID(n);
            this.netMan.sendMessage(messageS2CCharacterList);
        }
    }
}

