/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.rp;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.AccountResult;
import marauroa.common.game.CharacterResult;
import marauroa.common.game.IRPZone;
import marauroa.common.game.Perception;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPObjectInvalidException;
import marauroa.common.game.RPObjectNotFoundException;
import marauroa.common.game.Result;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageS2CPerception;
import marauroa.common.net.message.MessageS2CTransferREQ;
import marauroa.common.net.message.TransferContent;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.ActionInvalidException;
import marauroa.server.game.Statistics;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.rp.DebugInterface;
import marauroa.server.game.rp.IRPRuleProcessor;
import marauroa.server.game.rp.RPScheduler;
import marauroa.server.game.rp.RPWorld;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.validator.ConnectionValidator;

public class RPServerManager
extends Thread {
    private static final Logger logger = Log4J.getLogger(RPServerManager.class);
    private volatile boolean keepRunning;
    private volatile boolean isfinished;
    private long turnDuration;
    private int turn;
    private RPScheduler scheduler;
    private IRPRuleProcessor ruleProcessor;
    private RPWorld world;
    private Statistics stats;
    private INetworkServerManager netMan;
    private PlayerEntryContainer playerContainer;
    private List<PlayerEntry> playersToRemove;
    private Map<RPObject, List<TransferContent>> contentsToTransfer;

    public RPServerManager(INetworkServerManager iNetworkServerManager) throws Exception {
        super("RPServerManager");
        try {
            this.stats = Statistics.getStatistics();
            this.keepRunning = true;
            this.isfinished = false;
            this.scheduler = new RPScheduler();
            this.contentsToTransfer = new HashMap<RPObject, List<TransferContent>>();
            this.playerContainer = PlayerEntryContainer.getContainer();
            this.playersToRemove = new LinkedList<PlayerEntry>();
            this.netMan = iNetworkServerManager;
            Configuration configuration = Configuration.getConfiguration();
            this.initializeExtensions(configuration);
            String string = configuration.get("turn_length");
            this.turnDuration = Long.parseLong(string);
            this.turn = 0;
        }
        catch (Exception exception) {
            logger.warn("ABORT: Unable to create RPZone, RPRuleProcessor or RPAIManager instances", exception);
            throw exception;
        }
    }

    protected void initializeExtensions(Configuration configuration) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = Class.forName(configuration.get("world", "marauroa.server.game.rp.RPWorld"));
        this.world = (RPWorld)clazz.getDeclaredMethod("get", new Class[0]).invoke(null, (Object[])null);
        RPWorld.set(this.world);
        this.world.onInit();
        Class<?> clazz2 = Class.forName(configuration.get("ruleprocessor", "marauroa.server.game.rp.RPRuleProcessorImpl"));
        this.ruleProcessor = (IRPRuleProcessor)clazz2.getDeclaredMethod("get", new Class[0]).invoke(null, (Object[])null);
        this.ruleProcessor.setContext(this);
    }

    public int getTurn() {
        return this.turn;
    }

    public long getTurnDuration() {
        return this.turnDuration;
    }

    public void finish() {
        this.keepRunning = false;
        while (!this.isfinished) {
            Thread.yield();
        }
        try {
            this.world.onFinish();
        }
        catch (Exception exception) {
            logger.error("error while finishing RPServerManager", exception);
        }
    }

    public void addRPAction(RPObject rPObject, RPAction rPAction) throws ActionInvalidException {
        if (logger.isDebugEnabled()) {
            logger.debug("Added action: " + rPAction);
        }
        this.scheduler.addRPAction(rPObject, rPAction, this.ruleProcessor);
    }

    public boolean checkGameVersion(String string, String string2) {
        return this.ruleProcessor.checkGameVersion(string, string2);
    }

    public AccountResult createAccount(String string, String string2, String string3, String string4) {
        AccountResult accountResult = this.accountCreationPossible(string, string4);
        if (accountResult != null) {
            return accountResult;
        }
        return this.ruleProcessor.createAccount(string, string2, string3);
    }

    public AccountResult createAccountWithToken(String string, String string2, String string3, String string4) {
        AccountResult accountResult = this.accountCreationPossible(string, string4);
        if (accountResult != null) {
            return accountResult;
        }
        return this.ruleProcessor.createAccountWithToken(string, string2, string3);
    }

    private AccountResult accountCreationPossible(String string, String string2) {
        try {
            if (!Boolean.parseBoolean(Configuration.getConfiguration().get("allow_account_creation", "true"))) {
                return new AccountResult(Result.FAILED_CREATE_ON_MAIN_INSTEAD, string);
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
        try {
            if (DAORegister.get().get(AccountDAO.class).isAccountCreationLimitReached(string2)) {
                return new AccountResult(Result.FAILED_TOO_MANY, string);
            }
        }
        catch (SQLException sQLException) {
            logger.error(sQLException, sQLException);
            return new AccountResult(Result.FAILED_EXCEPTION, string);
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
            return new AccountResult(Result.FAILED_EXCEPTION, string);
        }
        return null;
    }

    public CharacterResult createCharacter(String string, String string2, RPObject rPObject, String string3) {
        try {
            if (!Boolean.parseBoolean(Configuration.getConfiguration().get("allow_account_creation", "true"))) {
                return new CharacterResult(Result.FAILED_CREATE_ON_MAIN_INSTEAD, string2, rPObject);
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
        try {
            if (DAORegister.get().get(CharacterDAO.class).isCharacterCreationLimitReached(string, string3)) {
                return new CharacterResult(Result.FAILED_TOO_MANY, string2, rPObject);
            }
        }
        catch (SQLException sQLException) {
            logger.error(sQLException, sQLException);
            return new CharacterResult(Result.FAILED_EXCEPTION, string2, rPObject);
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
            return new CharacterResult(Result.FAILED_EXCEPTION, string2, rPObject);
        }
        return this.ruleProcessor.createCharacter(string, string2, rPObject);
    }

    private Perception getPlayerPerception(PlayerEntry playerEntry) {
        Perception perception = null;
        IRPZone.ID iD = new IRPZone.ID(playerEntry.object.get("zoneid"));
        IRPZone iRPZone = this.world.getRPZone(iD);
        if (!playerEntry.requestedSync) {
            perception = iRPZone.getPerception(playerEntry.object, (byte)0);
        } else {
            playerEntry.requestedSync = false;
            perception = iRPZone.getPerception(playerEntry.object, (byte)1);
        }
        return perception;
    }

    private void sendPlayerPerception(PlayerEntry playerEntry, Perception perception, RPObject rPObject) {
        if (perception == null) {
            return;
        }
        MessageS2CPerception messageS2CPerception = new MessageS2CPerception(playerEntry.channel, perception);
        this.stats.add("Perceptions " + (perception.type == 0 ? "DELTA" : "SYNC"), 1);
        if (perception.type == 1) {
            RPObject rPObject2 = new RPObject();
            rPObject2.fill(rPObject);
            if (!rPObject.isHidden()) {
                rPObject2.clearVisible(true);
            }
            messageS2CPerception.setMyRPObject(rPObject2, null);
        } else {
            RPObject rPObject3 = new RPObject();
            RPObject rPObject4 = new RPObject();
            try {
                rPObject.getDifferences(rPObject3, rPObject4);
                if (!rPObject.isHidden()) {
                    rPObject3.clearVisible(false);
                    rPObject4.clearVisible(false);
                }
                if (rPObject3.size() == 0) {
                    rPObject3 = null;
                }
                if (rPObject4.size() == 0) {
                    rPObject4 = null;
                }
            }
            catch (Exception exception) {
                logger.error("Error getting object differences", exception);
                logger.error(rPObject);
                rPObject3 = null;
                rPObject4 = null;
            }
            messageS2CPerception.setMyRPObject(rPObject3, rPObject4);
        }
        messageS2CPerception.setClientID(playerEntry.clientid);
        messageS2CPerception.setPerceptionTimestamp(playerEntry.getPerceptionTimestamp());
        messageS2CPerception.setProtocolVersion(playerEntry.getProtocolVersion());
        this.netMan.sendMessage(messageS2CPerception);
    }

    private void buildPerceptions() {
        Object object;
        this.playersToRemove.clear();
        MessageS2CPerception.clearPrecomputedPerception();
        for (PlayerEntry playerEntry : this.playerContainer) {
            try {
                if (playerEntry.isTimeout()) {
                    logger.info("Request (TIMEOUT) disconnection of Player " + playerEntry.getAddress());
                    this.playersToRemove.add(playerEntry);
                    continue;
                }
                if (playerEntry.state != ClientState.GAME_BEGIN) continue;
                object = this.getPlayerPerception(playerEntry);
                this.sendPlayerPerception(playerEntry, (Perception)object, playerEntry.object);
            }
            catch (Exception exception) {
                logger.error("Removing player(" + playerEntry.clientid + ") because it caused a Exception while contacting it", exception);
                this.playersToRemove.add(playerEntry);
            }
        }
        for (PlayerEntry playerEntry : this.playersToRemove) {
            logger.warn("RP Disconnecting entry: " + playerEntry);
            object = playerEntry.channel.getInternalChannel();
            if (object instanceof SocketChannel && !((SocketChannel)object).isOpen()) {
                logger.warn("Timeout of closed socket");
                this.playerContainer.remove(playerEntry.clientid);
            }
            this.netMan.disconnectClient(playerEntry.channel);
        }
    }

    public boolean onInit(RPObject rPObject) throws RPObjectInvalidException {
        if (!DebugInterface.get().onInit(rPObject)) {
            return false;
        }
        return this.ruleProcessor.onInit(rPObject);
    }

    public boolean onExit(RPObject rPObject) throws RPObjectNotFoundException {
        this.scheduler.clearRPActions(rPObject);
        this.contentsToTransfer.remove(rPObject);
        if (!DebugInterface.get().onExit(rPObject)) {
            return false;
        }
        return this.ruleProcessor.onExit(rPObject);
    }

    public void onTimeout(RPObject rPObject) throws RPObjectNotFoundException {
        DebugInterface.get().onTimeout(rPObject);
        this.scheduler.clearRPActions(rPObject);
        this.contentsToTransfer.remove(rPObject);
        this.ruleProcessor.onTimeout(rPObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTransferContent() {
        Map<RPObject, List<TransferContent>> map = this.contentsToTransfer;
        synchronized (map) {
            for (Map.Entry<RPObject, List<TransferContent>> entry : this.contentsToTransfer.entrySet()) {
                Object object;
                RPObject rPObject = entry.getKey();
                List<TransferContent> list = entry.getValue();
                PlayerEntry playerEntry = this.playerContainer.get(rPObject);
                if (playerEntry == null) {
                    logger.warn("Entry for player (" + rPObject + ") does not exist: " + this.playerContainer, new Throwable());
                    continue;
                }
                if (list == null) {
                    logger.warn("content is null");
                }
                if (!playerEntry.contentToTransfer.isEmpty()) {
                    if (playerEntry.contentToTransfer.size() > 30) {
                        object = playerEntry.contentToTransfer;
                        synchronized (object) {
                            for (int i = 0; i < 10; ++i) {
                                playerEntry.contentToTransfer.remove(0);
                            }
                        }
                    }
                    logger.warn("Adding to existing contentToTransfer for player " + playerEntry.character + " old: " + playerEntry.contentToTransfer + " added " + list);
                }
                playerEntry.contentToTransfer.addAll(list);
                object = new MessageS2CTransferREQ(playerEntry.channel, list);
                ((Message)object).setClientID(playerEntry.clientid);
                ((Message)object).setProtocolVersion(playerEntry.getProtocolVersion());
                this.netMan.sendMessage((Message)object);
            }
            this.contentsToTransfer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferContent(RPObject rPObject, List<TransferContent> list) {
        Map<RPObject, List<TransferContent>> map = this.contentsToTransfer;
        synchronized (map) {
            this.contentsToTransfer.put(rPObject, list);
        }
    }

    public void transferContent(RPObject rPObject, TransferContent transferContent) {
        LinkedList<TransferContent> linkedList = new LinkedList<TransferContent>();
        linkedList.add(transferContent);
        this.transferContent(rPObject, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long l = System.nanoTime();
            long l2 = 0L;
            long[] lArray = new long[12];
            while (this.keepRunning) {
                long l3 = System.nanoTime();
                logger.debug("Turn time elapsed: " + (l3 - l) / 1000L + " microsecs");
                long l4 = this.turnDuration - (l3 - l) / 1000000L;
                if (l4 < 0L) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (long l5 : lArray) {
                        stringBuilder.append(" " + (l5 - l2));
                    }
                    logger.warn("Turn duration overflow by " + -l4 + " ms: " + stringBuilder.toString());
                } else if (l4 > this.turnDuration) {
                    logger.error("Delay bigger than Turn duration. [delay: " + l4 + "] [turnDuration:" + this.turnDuration + "]");
                    l4 = 0L;
                }
                if (l4 > 0L) {
                    try {
                        Thread.sleep(l4);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                l = System.nanoTime();
                l2 = System.currentTimeMillis();
                this.playerContainer.getLock().requestWriteLock();
                try {
                    lArray[0] = System.currentTimeMillis();
                    this.scheduler.nextTurn();
                    lArray[1] = System.currentTimeMillis();
                    this.scheduler.visit(this.ruleProcessor);
                    lArray[2] = System.currentTimeMillis();
                    this.ruleProcessor.endTurn();
                    lArray[3] = System.currentTimeMillis();
                    this.deliverTransferContent();
                    lArray[4] = System.currentTimeMillis();
                    this.buildPerceptions();
                    lArray[5] = System.currentTimeMillis();
                    this.savePlayersPeriodicly();
                    lArray[6] = System.currentTimeMillis();
                    this.world.nextTurn();
                    lArray[7] = System.currentTimeMillis();
                    ++this.turn;
                    this.ruleProcessor.beginTurn();
                    lArray[8] = System.currentTimeMillis();
                }
                finally {
                    this.playerContainer.getLock().releaseLock();
                    lArray[9] = System.currentTimeMillis();
                }
                try {
                    this.stats.set("Objects now", this.world.size());
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                lArray[10] = System.currentTimeMillis();
                TransactionPool.get().kickHangingTransactionsOfThisThread();
                lArray[11] = System.currentTimeMillis();
            }
        }
        catch (Throwable throwable) {
            logger.error("Unhandled exception, server will shut down.", throwable);
        }
        finally {
            this.isfinished = true;
        }
    }

    private void savePlayersPeriodicly() {
        for (PlayerEntry playerEntry : this.playerContainer) {
            try {
                if (playerEntry.getThisPerceptionTimestamp() % 2000 != 1999) continue;
                playerEntry.storeRPObject(playerEntry.object);
            }
            catch (Exception exception) {
                String string = "null";
                if (playerEntry != null) {
                    string = playerEntry.character;
                }
                logger.error("Error while storing player " + string, exception);
            }
        }
    }

    public void disconnectPlayer(RPObject rPObject) {
        PlayerEntry playerEntry = this.playerContainer.get(rPObject);
        if (playerEntry == null) {
            logger.warn("There is no PlayerEntry associated to this RPObject.");
            return;
        }
        this.netMan.disconnectClient(playerEntry.channel);
    }

    public ConnectionValidator getValidator() {
        return this.netMan.getValidator();
    }

    public String getMimeTypeForResource(String string) {
        return this.ruleProcessor.getMimeTypeForResource(string);
    }

    public InputStream getResource(String string) {
        return this.ruleProcessor.getResource(string);
    }
}

