/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.flood;

import marauroa.common.net.Channel;

public class FloodMeasure {
    public Channel channel;
    public long lasttimestamp;
    public int sendMessages;
    public int sendBytes;
    public int floodWarnings;

    public FloodMeasure(Channel channel) {
        this.channel = channel;
        this.floodWarnings = 0;
        this.resetPerSecondData();
    }

    public void resetPerSecondData() {
        this.lasttimestamp = System.currentTimeMillis();
        this.sendMessages = 0;
        this.sendBytes = 0;
    }

    public void addMessage(int n) {
        ++this.sendMessages;
        this.sendBytes += n;
    }

    public void warning() {
        ++this.floodWarnings;
    }

    public int getBytesPerSecond() {
        int n = (int)((System.currentTimeMillis() - this.lasttimestamp) / 1000L) + 1;
        return this.sendBytes / n;
    }

    public int getMessagesPerSecond() {
        int n = (int)((System.currentTimeMillis() - this.lasttimestamp) / 1000L) + 1;
        return this.sendMessages / n;
    }

    public int getWarnings() {
        return this.floodWarnings;
    }

    public int sinceLastReset() {
        return (int)((System.currentTimeMillis() - this.lasttimestamp) / 1000L);
    }

    public void resetWarnings() {
        this.floodWarnings = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(" time: " + this.sinceLastReset());
        stringBuilder.append(" send bytes: " + this.sendBytes);
        stringBuilder.append(" send messages: " + this.sendMessages);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

