/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.validator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import marauroa.common.Utility;

public class InetAddressMask {
    private byte[] address;
    private byte[] mask;

    public InetAddressMask(String string, String string2) {
        this(InetAddressMask.string2bytes(string), InetAddressMask.string2bytes(string2));
    }

    public InetAddressMask(byte[] byArray, byte[] byArray2) {
        this.address = Utility.copy(byArray);
        this.mask = Utility.copy(byArray2);
        byArray[0] = (byte)(byArray[0] & byArray2[0]);
        byArray[1] = (byte)(byArray[1] & byArray2[1]);
        byArray[2] = (byte)(byArray[2] & byArray2[2]);
        byArray[3] = (byte)(byArray[3] & byArray2[3]);
    }

    public boolean matches(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        byArray[0] = (byte)(byArray[0] & this.mask[0]);
        byArray[1] = (byte)(byArray[1] & this.mask[1]);
        byArray[2] = (byte)(byArray[2] & this.mask[2]);
        byArray[3] = (byte)(byArray[3] & this.mask[3]);
        boolean bl = true;
        bl = bl && (byArray[3] ^ this.address[3]) == 0;
        bl = bl && (byArray[2] ^ this.address[2]) == 0;
        bl = bl && (byArray[1] ^ this.address[1]) == 0;
        bl = bl && (byArray[0] ^ this.address[0]) == 0;
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.address);
        n = 31 * n + Arrays.hashCode(this.mask);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof InetAddressMask) {
            InetAddressMask inetAddressMask = (InetAddressMask)object;
            return Arrays.equals(this.address, inetAddressMask.address) && Arrays.equals(this.mask, inetAddressMask.mask);
        }
        return false;
    }

    public String toString() {
        try {
            return InetAddress.getByAddress(this.address).getHostAddress() + "/" + InetAddress.getByAddress(this.mask).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    public static byte[] string2bytes(String string) {
        String[] stringArray = string.split("\\.");
        byte[] byArray = new byte[4];
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[0] = 0;
        for (int i = 0; i < stringArray.length && i < 4; ++i) {
            byArray[i] = (byte)Integer.parseInt(stringArray[i]);
        }
        return byArray;
    }
}

