/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.web;

import jakarta.websocket.CloseReason;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.game.rp.DebugInterface;
import marauroa.server.net.web.WebSocketConnectionManager;
import marauroa.server.net.web.WebSocketRequestWrapper;

@ServerEndpoint(value="/wsinternal")
public class WebSocketChannel {
    private static Logger logger = Log4J.getLogger(WebSocketChannel.class);
    private static WebSocketConnectionManager webSocketServerManager = WebSocketConnectionManager.get();
    private Session socketSession;
    private String username;
    private String useragent;
    private InetSocketAddress address;

    @OnOpen
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.socketSession = session;
        Map map = session.getRequestParameterMap();
        if (!WebSocketRequestWrapper.SECRET.equals(((List)map.get("secret")).get(0))) {
            logger.warn("Direct request to /wsinternal");
            this.close();
            return;
        }
        this.address = new InetSocketAddress((String)((List)map.get("address")).get(0), 0);
        this.useragent = (String)((List)map.get("useragent")).get(0);
        String string = (String)((List)map.get("origin")).get(0);
        try {
            String string2 = Configuration.getConfiguration().get("http_origin");
            if (!this.validateOrigin(string, string2)) {
                logger.warn("Expected origin " + string2 + " from client " + this.address + " but got " + string);
                this.close();
                return;
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
            this.close();
            return;
        }
        this.username = (String)((List)map.get("marauroa_authenticated_usernam")).get(0);
        if (this.username == null) {
            logger.warn("No username in request by" + this.address);
            this.close();
            return;
        }
        webSocketServerManager.onConnect(this);
        logger.debug("Socket Connected: " + session);
    }

    private boolean validateOrigin(String string, String string2) {
        String[] stringArray;
        if (string2 == null) {
            return true;
        }
        for (String string3 : stringArray = string2.split(",")) {
            if (!string3.equals(string)) continue;
            return true;
        }
        return false;
    }

    @OnMessage
    public void onWebSocketText(String string) {
        String string2 = DebugInterface.get().onMessage(this.useragent, string);
        webSocketServerManager.onMessage(this, string2);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        webSocketServerManager.onDisconnect(this);
        logger.debug("WebSocket Closed");
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        if (throwable instanceof SocketTimeoutException) {
            this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Timeout"));
            return;
        }
        logger.error(throwable, throwable);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void sendMessage(String string) {
        try {
            RemoteEndpoint.Basic basic = this.socketSession.getBasicRemote();
            if (basic != null) {
                basic.sendText(string);
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
        catch (IllegalStateException illegalStateException) {
            logger.warn(illegalStateException);
        }
    }

    public void close() {
        try {
            this.socketSession.close();
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
    }
}

