/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;

public class HttpClient {
    private final String urlString;
    private HttpURLConnection connection;
    private InputStream is;
    private ProgressListener progressListener;
    private static final int timeout = 1500;
    private boolean tryVeryHard;

    public HttpClient(String string) {
        this.urlString = string;
    }

    HttpClient(String string, boolean bl) {
        this.urlString = string;
        this.tryVeryHard = bl;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    private void openInputStream() {
        try {
            URL uRL = new URL(this.urlString);
            int n = 0;
            int n2 = 1500;
            while (this.is == null) {
                ++n;
                try {
                    this.connection = (HttpURLConnection)uRL.openConnection();
                    this.connection.setConnectTimeout(n2);
                    this.connection.setInstanceFollowRedirects(true);
                    this.connection.setUseCaches(false);
                    int n3 = this.connection.getResponseCode();
                    if (n3 != 200) {
                        if (this.isRedirect(n3)) {
                            boolean bl = true;
                            HashSet<String> hashSet = new HashSet<String>();
                            hashSet.add(this.urlString);
                            while (bl) {
                                String string = this.connection.getHeaderField("Location");
                                if (!hashSet.contains(string)) {
                                    hashSet.add(string);
                                    this.connection = (HttpURLConnection)new URL(string).openConnection();
                                    bl = this.isRedirect(this.connection.getResponseCode());
                                    continue;
                                }
                                System.err.println(String.format("The URL '%s' leads into a circular redirect.", uRL));
                                this.connection = null;
                            }
                        } else {
                            System.err.println("HttpServer returned an error code (" + this.urlString + "): " + n3);
                            this.connection = null;
                        }
                    }
                    if (this.connection != null) {
                        this.is = this.connection.getInputStream();
                        if (n > 1) {
                            System.err.println("Retry successful");
                        }
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    System.err.println("Timeout (" + this.urlString + "):  " + socketTimeoutException.toString());
                }
                n2 *= 2;
                if (this.tryVeryHard && n <= 3) continue;
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("Error connecting to http-Server (" + this.urlString + "): ");
            exception.printStackTrace(System.err);
        }
    }

    private boolean isRedirect(int n) {
        return n == 302 || n == 301 || n == 303;
    }

    public InputStream getInputStream() {
        this.openInputStream();
        return this.is;
    }

    void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                iOException.printStackTrace(System.err);
            }
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public String fetchFirstLine() {
        String string = null;
        try {
            this.openInputStream();
            if (this.is == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
            string = bufferedReader.readLine();
            bufferedReader.close();
            this.connection.disconnect();
        }
        catch (Exception exception) {
            System.err.println("Error connecting to http-Server: ");
            exception.printStackTrace(System.err);
        }
        return string;
    }

    Properties fetchProperties() {
        Properties properties = null;
        this.openInputStream();
        if (this.is == null) {
            return properties;
        }
        try {
            properties = new Properties();
            properties.load(this.is);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace(System.err);
        }
        this.close();
        return properties;
    }

    boolean fetchFile(String string) {
        boolean bl = false;
        this.openInputStream();
        if (this.is == null) {
            return bl;
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            this.copyStream(this.is, bufferedOutputStream);
            this.connection.disconnect();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        return bl;
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        int n2 = n = inputStream.read(byArray);
        while (n > -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
            if (n <= 0) continue;
            n2 += n;
            if (this.progressListener == null) continue;
            this.progressListener.onDownloading(n2);
        }
        inputStream.close();
        outputStream.close();
        if (this.progressListener != null) {
            this.progressListener.onDownloadCompleted(n2);
        }
    }

    static interface ProgressListener {
        public void onDownloading(int var1);

        public void onDownloadCompleted(int var1);
    }
}

