/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.client.update.HttpClient;
import games.stendhal.client.update.UpdateProgressBarHyperLinkListener;
import games.stendhal.client.update.UpdateProgressBarMetaRefreshSupport;
import games.stendhal.client.update.UpdateProgressBarWindowListener;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

class UpdateProgressBar
extends JFrame
implements HttpClient.ProgressListener {
    private static final long serialVersionUID = -1607102841664745919L;
    private int max = 100;
    private String urlBase = null;
    private String fromVersion = null;
    private String toVersion = null;
    private int sizeOfLastFiles;
    private JProgressBar progressBar;
    private JEditorPane browser;

    UpdateProgressBar(int n, String string, String string2, String string3) {
        super("Pobieram...", MouseInfo.getPointerInfo().getDevice().getDefaultConfiguration());
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new UpdateProgressBarWindowListener());
        this.max = n;
        this.urlBase = string;
        this.fromVersion = string2;
        this.toVersion = string3;
        try {
            URL uRL = this.getClass().getClassLoader().getResource(ClientGameConfiguration.get("GAME_ICON"));
            this.setIconImage(new ImageIcon(uRL).getImage());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.initializeComponents();
        this.pack();
    }

    private void initializeComponents() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.fromVersion == null) {
            jPanel.add(new JLabel("Prosz\u0119 poczeka\u0107 na pobranie " + ClientGameConfiguration.get("GAME_NAME") + "..."));
        } else {
            jPanel.add(new JLabel("Pobieram aktualizacje..."));
        }
        jPanel.add(Box.createVerticalStrut(5));
        this.progressBar = new JProgressBar(0, this.max);
        this.progressBar.setStringPainted(false);
        this.progressBar.setValue(0);
        jPanel.add(this.progressBar);
        jPanel.add(Box.createVerticalStrut(5));
        if (this.urlBase != null) {
            this.browser = new JEditorPane();
            this.browser.setContentType("text/html");
            this.browser.setEditable(false);
            Dimension dimension = new Dimension(600, 440);
            this.browser.setPreferredSize(dimension);
            this.browser.addPropertyChangeListener("page", new UpdateProgressBarMetaRefreshSupport());
            this.browser.addHyperlinkListener(new UpdateProgressBarHyperLinkListener());
            Dimension dimension2 = new Dimension(640, 480);
            this.setPreferredSize(dimension2);
            try {
                this.browser.setPage(this.urlBase + this.fromVersion + "/" + this.toVersion + ".html");
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            JScrollPane jScrollPane = new JScrollPane(this.browser);
            jPanel.add(jScrollPane);
        }
    }

    @Override
    public void onDownloading(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateProgressBar.this.progressBar.setValue(UpdateProgressBar.this.sizeOfLastFiles + n);
            }
        });
    }

    @Override
    public void onDownloadCompleted(int n) {
        this.sizeOfLastFiles += n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateProgressBar.this.progressBar.setValue(UpdateProgressBar.this.sizeOfLastFiles);
            }
        });
    }

    public static void main(String[] stringArray) {
        UpdateProgressBar updateProgressBar = new UpdateProgressBar(100, "https://arianne-project.org/stendhal/greeting/", null, "0.88");
        updateProgressBar.onDownloading(50);
        updateProgressBar.setVisible(true);
    }
}

