/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.stendhal;
import games.stendhal.common.Debug;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import marauroa.common.crypto.Hash;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPClass;
import marauroa.common.io.Persistence;
import org.apache.log4j.Logger;

public final class CStatusSender {
    private static final Logger logger = Logger.getLogger(CStatusSender.class);
    private static final String FILE_NAME = "cid";
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!$/()@";

    public static void send() {
        Object object;
        Class<?> clazz;
        String string = CStatusSender.readID();
        if (string == null) {
            string = CStatusSender.generateRandomString();
            CStatusSender.saveID(string);
        }
        RPAction rPAction = new RPAction();
        if (RPClass.getRPClass((String)"cstatus") != null) {
            rPAction.put("type", "cstatus");
        } else {
            rPAction.put("type", FILE_NAME);
        }
        if (string != null) {
            rPAction.put(FILE_NAME, string);
        }
        String string2 = "1.40.3";
        if (Debug.PRE_RELEASE_VERSION != null) {
            string2 = string2 + " - " + Debug.PRE_RELEASE_VERSION;
        }
        rPAction.put("version", string2);
        try {
            Certificate[] certificateArray;
            clazz = Class.forName("games.stendhal.client.update.Starter");
            if (clazz != null && (object = clazz.getSigners()) instanceof Certificate[] && (certificateArray = (Certificate[])object).length > 0) {
                byte[] byArray = certificateArray[0].getPublicKey().getEncoded();
                rPAction.put("dist", Hash.toHexString((byte[])Hash.hash((byte[])byArray)));
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable, throwable);
        }
        try {
            clazz = Class.forName("games.stendhal.client.StendhalBuild");
            object = clazz.getMethod("getBuildNumber", new Class[0]).invoke(null, new Object[0]);
            if (object != null) {
                rPAction.put("build", object.toString());
            }
        }
        catch (Throwable throwable) {
            logger.debug((Object)throwable, throwable);
        }
        ClientSingletonRepository.getClientFramework().send(rPAction);
    }

    private static String generateRandomString() {
        StringBuilder stringBuilder = new StringBuilder();
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < 32; ++i) {
            int n = (int)(secureRandom.nextFloat() * (float)CHARS.length());
            stringBuilder.append(CHARS.charAt(n));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readID() {
        String string = null;
        try {
            InputStream inputStream = Persistence.get().getInputStream(false, stendhal.getGameFolder(), FILE_NAME);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = bufferedInputStream.read();
                while (n != -1) {
                    byte by = (byte)n;
                    byteArrayOutputStream.write(by);
                    n = bufferedInputStream.read();
                }
                string = byteArrayOutputStream.toString("UTF-8").trim();
            }
            finally {
                bufferedInputStream.close();
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private static void saveID(String string) {
        try {
            OutputStream outputStream = Persistence.get().getOutputStream(false, stendhal.getGameFolder(), FILE_NAME);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");){
                outputStreamWriter.write(string);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)("Can't write " + stendhal.getGameFolder() + FILE_NAME), (Throwable)iOException);
        }
    }
}

