/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.stendhal;
import games.stendhal.common.CRC;
import games.stendhal.common.IO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import marauroa.common.crypto.Hash;
import marauroa.common.net.message.TransferContent;
import org.apache.log4j.Logger;

class Cache {
    private static Logger logger = Logger.getLogger(Cache.class);

    Cache() {
    }

    protected void init() {
        try {
            File file = new File(stendhal.getGameFolder());
            if (!file.exists() && !file.mkdirs()) {
                logger.error((Object)("Can't create " + file.getAbsolutePath() + " folder"));
            } else if (file.exists() && file.isFile() && (!file.delete() || !file.mkdirs())) {
                logger.error((Object)("Can't removing file " + file.getAbsolutePath() + " and creating a folder instead."));
            }
            file = new File(stendhal.getGameFolder() + "cache");
            if (!file.exists() && !file.mkdir()) {
                logger.error((Object)("Can't create " + file.getAbsolutePath() + " folder"));
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)"cannot create cach folder", (Throwable)runtimeException);
        }
    }

    protected InputStream getItem(TransferContent transferContent) {
        if (transferContent.name.indexOf("..") > -1) {
            logger.error((Object)("Cannot get item from cache because .. is not allowed in name " + transferContent.name));
            return null;
        }
        String string = this.getFilename(transferContent.name);
        byte[] byArray = IO.readFileContent(string);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = transferContent.getTransmittedHash();
        if (byArray2 != null) {
            byte[] byArray3 = Hash.hash((byte[])byArray);
            if (Arrays.equals(byArray2, byArray3)) {
                return new ByteArrayInputStream(byArray);
            }
            return null;
        }
        int n = transferContent.timestamp;
        short s = CRC.cmpCRC(byArray);
        if (n == s) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(TransferContent transferContent, byte[] byArray) {
        try {
            if (transferContent.name.indexOf("..") > -1) {
                logger.error((Object)("Cannot store item to cache because .. is not allowed in name " + transferContent.name));
                return;
            }
            String string = stendhal.getGameFolder() + "cache/" + transferContent.name;
            try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                ((OutputStream)fileOutputStream).write(byArray);
            }
            logger.debug((Object)("Content " + transferContent.name + " cached now."));
        }
        catch (IOException iOException) {
            logger.error((Object)"store", (Throwable)iOException);
        }
    }

    String getFilename(String string) {
        if (string.indexOf("..") > -1) {
            logger.error((Object)("Cannot access item in cache because .. is not allowed in name " + string));
            return null;
        }
        return stendhal.getGameFolder() + "cache/" + string;
    }
}

