/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MemoryCache<K, V> {
    private final Map<K, Reference<V>> map = new ConcurrentHashMap<K, Reference<V>>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public V get(K k) {
        Reference<V> reference;
        this.pruneMap();
        if (k != null && (reference = this.map.get(k)) != null) {
            return reference.get();
        }
        return null;
    }

    public void put(K k, V v) {
        this.pruneMap();
        if (k == null || v == null) {
            return;
        }
        Entry<K, V> entry = new Entry<K, V>(k, v, this.queue);
        this.map.put(k, entry);
    }

    private void pruneMap() {
        Reference<V> reference = this.queue.poll();
        while (reference != null) {
            this.map.remove(((Entry)reference).key);
            reference = this.queue.poll();
        }
    }

    static class Entry<K, V>
    extends SoftReference<V> {
        K key;

        Entry(K k, V v, ReferenceQueue<? super V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }
    }
}

