/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.Cache;
import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameLoop;
import games.stendhal.client.GameObjects;
import games.stendhal.client.PerceptionDispatcher;
import games.stendhal.client.PerceptionToObject;
import games.stendhal.client.RPObjectChangeDispatcher;
import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.StendhalPerceptionListener;
import games.stendhal.client.UserContext;
import games.stendhal.client.Zone;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.login.CharacterDialog;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.client.update.HttpClient;
import games.stendhal.common.Direction;
import games.stendhal.common.NotificationType;
import games.stendhal.common.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import marauroa.client.BannedAddressException;
import marauroa.client.ClientFramework;
import marauroa.client.TimeoutException;
import marauroa.client.net.IPerceptionListener;
import marauroa.client.net.PerceptionHandler;
import marauroa.common.game.CharacterResult;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.MessageS2CPerception;
import marauroa.common.net.message.TransferContent;
import org.apache.log4j.Logger;

public class StendhalClient
extends ClientFramework {
    private static final Logger logger = Logger.getLogger(StendhalClient.class);
    private final Map<RPObject.ID, RPObject> worldObjects;
    private final PerceptionHandler handler;
    private final RPObjectChangeDispatcher rpobjDispatcher;
    private final StaticGameLayers staticLayers;
    private final GameObjects gameObjects;
    protected static StendhalClient client;
    private final Cache cache;
    private final List<Direction> directions;
    private static List<Integer> pressedStateKeys;
    private static final String LOG4J_PROPERTIES = "data/conf/log4j.properties";
    private String userName = "";
    private String character;
    private final UserContext userContext;
    private final List<ZoneChangeListener> zoneChangeListeners = new ArrayList<ZoneChangeListener>();
    private int contentToLoad;
    private boolean inBatchUpdate;
    private final ReentrantLock drawingSemaphore = new ReentrantLock();
    private Zone currentZone;
    private JFrame splashScreen;

    public static StendhalClient get() {
        return client;
    }

    public static void resetClient() {
        client = null;
    }

    StendhalClient(UserContext userContext, PerceptionDispatcher perceptionDispatcher) {
        super(LOG4J_PROPERTIES);
        client = this;
        ClientSingletonRepository.setClientFramework(this);
        this.worldObjects = new HashMap<RPObject.ID, RPObject>();
        this.staticLayers = new StaticGameLayers();
        this.gameObjects = GameObjects.createInstance(this.staticLayers);
        this.userContext = userContext;
        this.rpobjDispatcher = new RPObjectChangeDispatcher(this.gameObjects, userContext);
        PerceptionToObject perceptionToObject = new PerceptionToObject();
        perceptionDispatcher.register(perceptionToObject);
        StendhalPerceptionListener stendhalPerceptionListener = new StendhalPerceptionListener(perceptionDispatcher, this.rpobjDispatcher, userContext, this.worldObjects);
        this.handler = new PerceptionHandler((IPerceptionListener)stendhalPerceptionListener);
        this.cache = new Cache();
        this.cache.init();
        this.directions = new ArrayList<Direction>(2);
    }

    protected String getGameName() {
        return stendhal.GAME_NAME.toLowerCase(Locale.ENGLISH);
    }

    protected String getVersionNumber() {
        return stendhal.VERSION;
    }

    public StaticGameLayers getStaticGameLayers() {
        return this.staticLayers;
    }

    public GameObjects getGameObjects() {
        return this.gameObjects;
    }

    private void onBeforeSync() {
        for (RPObject rPObject : this.worldObjects.values()) {
            if (rPObject == this.userContext.getPlayer()) continue;
            this.rpobjDispatcher.dispatchRemoved(rPObject);
        }
        if (this.userContext.getPlayer() != null) {
            this.rpobjDispatcher.dispatchRemoved(this.userContext.getPlayer());
        }
        this.gameObjects.clear();
    }

    protected void onPerception(MessageS2CPerception messageS2CPerception) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("message: " + messageS2CPerception));
            }
            if (messageS2CPerception.getPerceptionType() == 1) {
                this.onBeforeSync();
            }
            this.handler.apply(messageS2CPerception, this.worldObjects);
        }
        catch (Exception exception) {
            logger.error((Object)("error processing message " + messageS2CPerception), (Throwable)exception);
        }
        if (this.inBatchUpdate && this.contentToLoad == 0) {
            this.validateAndUpdateZone(this.currentZone);
            this.inBatchUpdate = false;
            while (this.drawingSemaphore.getHoldCount() > 0) {
                this.drawingSemaphore.unlock();
            }
        }
    }

    protected List<TransferContent> onTransferREQ(List<TransferContent> list) {
        this.inBatchUpdate = true;
        logger.debug((Object)"Batch update started");
        String string = this.currentZone != null ? this.currentZone.getName() : null;
        for (TransferContent object2 : list) {
            String string2 = object2.name;
            int n = string2.indexOf(".0_floor");
            if (n <= -1) continue;
            this.currentZone = new Zone(string2.substring(0, n));
            break;
        }
        if (this.currentZone != null) {
            boolean bl = !this.currentZone.getName().equals(string);
            this.currentZone.setUpdate(!bl);
            if (bl) {
                logger.debug((Object)"Preparing for zone change");
                this.drawingSemaphore.lock();
                this.staticLayers.clear();
                for (ZoneChangeListener zoneChangeListener : this.zoneChangeListeners) {
                    zoneChangeListener.onZoneChange(this.currentZone);
                }
            }
        }
        this.contentToLoad = 0;
        for (TransferContent transferContent : list) {
            InputStream inputStream;
            if (transferContent.name != null && transferContent.name.endsWith(".data_map")) {
                this.currentZone.requireDataLayer();
            }
            if ((inputStream = this.cache.getItem(transferContent)) != null) {
                transferContent.ack = false;
                try {
                    this.contentHandling(transferContent.name, inputStream);
                    inputStream.close();
                }
                catch (Exception exception) {
                    logger.error((Object)exception, (Throwable)exception);
                    transferContent.ack = true;
                }
            } else {
                logger.debug((Object)("Content " + transferContent.name + " is NOT on cache. We have to transfer"));
                transferContent.ack = true;
            }
            if (!transferContent.ack) continue;
            ++this.contentToLoad;
        }
        return list;
    }

    public void addZoneChangeListener(ZoneChangeListener zoneChangeListener) {
        this.zoneChangeListeners.add(zoneChangeListener);
    }

    public boolean isInTransfer() {
        return this.contentToLoad != 0 && this.currentZone != null && !this.currentZone.isUpdate();
    }

    private void contentHandling(String string, InputStream inputStream) throws IOException, ClassNotFoundException {
        int n = string.indexOf(46);
        if (string.endsWith(".jar")) {
            inputStream.close();
            DataLoader.addJarFile(this.cache.getFilename(string));
        } else if (n > -1) {
            String string2 = string.substring(n + 1);
            this.currentZone.addLayer(string2, inputStream);
        }
    }

    protected void onTransfer(List<TransferContent> list) {
        for (TransferContent transferContent : list) {
            try {
                if (transferContent.cacheable) {
                    this.cache.store(transferContent, transferContent.data);
                }
                if (transferContent.name.startsWith(this.currentZone.getName() + ".")) {
                    this.contentHandling(transferContent.name, new ByteArrayInputStream(transferContent.data));
                    continue;
                }
                ++this.contentToLoad;
            }
            catch (Exception exception) {
                logger.error((Object)"onTransfer", (Throwable)exception);
            }
        }
        this.contentToLoad -= list.size();
        if (this.contentToLoad < 0) {
            logger.warn((Object)"More data transfer than expected");
            this.contentToLoad = 0;
        }
    }

    protected void onAvailableCharacters(String[] stringArray) {
    }

    protected void onAvailableCharacterDetails(final Map<String, RPObject> map) {
        if (map.isEmpty()) {
            if (this.character == null) {
                this.character = this.getAccountUsername();
            }
            logger.warn((Object)("The requested character is not available, trying to create character " + this.character));
            RPObject rPObject = new RPObject();
            try {
                CharacterResult characterResult = this.createCharacter(this.character, rPObject);
                if (characterResult.getResult().failed()) {
                    logger.error((Object)characterResult.getResult().getText());
                    JOptionPane.showMessageDialog(this.splashScreen, characterResult.getResult().getText());
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
            return;
        }
        if (this.character != null && map.containsKey(this.character)) {
            try {
                this.chooseCharacter(this.character);
                stendhal.setDoLogin();
                if (this.splashScreen != null) {
                    this.splashScreen.dispose();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"StendhalClient::onAvailableCharacters", (Throwable)exception);
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CharacterDialog(map, StendhalClient.this.splashScreen);
            }
        });
    }

    protected void onServerInfo(String[] stringArray) {
    }

    protected void onPreviousLogins(final List<String> list) {
        GameLoop.get().runOnce(new Runnable(){

            @Override
            public void run() {
                for (String string : list) {
                    NotificationType notificationType = string.indexOf("FAILED") != -1 ? NotificationType.WARNING : NotificationType.SERVER;
                    ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine("Poprzednie " + string, notificationType));
                }
            }
        });
    }

    public boolean addDirection(Direction direction, boolean bl) {
        int n;
        RPAction rPAction;
        Direction direction2 = direction.oppositeDirection();
        if (this.directions.remove((Object)direction2)) {
            rPAction = new RPAction();
            rPAction.put("type", "move");
            rPAction.put("dir", -direction2.get());
            this.send(rPAction);
        }
        if ((n = this.directions.indexOf((Object)direction)) != -1) {
            if (n == this.directions.size() - 1) {
                logger.debug((Object)("Ignoring same direction: " + (Object)((Object)direction)));
                return false;
            }
            this.directions.remove(n);
        }
        this.directions.add(direction);
        rPAction = bl ? new FaceRPAction(direction) : new MoveRPAction(direction);
        this.send(rPAction);
        return true;
    }

    public void removeDirection(Direction direction, boolean bl) {
        RPAction rPAction = new RPAction();
        rPAction.put("type", "move");
        rPAction.put("dir", -direction.get());
        this.send(rPAction);
        this.directions.remove((Object)direction);
        int n = this.directions.size();
        if (n == 0) {
            rPAction = new RPAction();
            rPAction.put("type", "stop");
        } else {
            rPAction = bl ? new FaceRPAction(this.directions.get(n - 1)) : new MoveRPAction(this.directions.get(n - 1));
        }
        this.send(rPAction);
    }

    public void stop() {
        this.directions.clear();
        RPAction rPAction = new RPAction();
        rPAction.put("type", "stop");
        rPAction.put("attack", "");
        this.send(rPAction);
    }

    public void setAccountUsername(String string) {
        this.userContext.setName(string);
        this.userName = string;
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String string) {
        this.character = string;
    }

    public void setSplashScreen(JFrame jFrame) {
        this.splashScreen = jFrame;
    }

    public String getAccountUsername() {
        return this.userName;
    }

    boolean isUser(RPObject rPObject) {
        if (rPObject.getRPClass().subclassOf("player")) {
            return this.getCharacter().equalsIgnoreCase(rPObject.get("name"));
        }
        return false;
    }

    public Cache getCache() {
        return this.cache;
    }

    public RPObject getPlayer() {
        return this.userContext.getPlayer();
    }

    public synchronized boolean chooseCharacter(String string) throws TimeoutException, InvalidVersionException, BannedAddressException {
        boolean bl = super.chooseCharacter(string);
        if (bl) {
            this.character = string;
        }
        return bl;
    }

    public void releaseDrawingSemaphore() {
        this.drawingSemaphore.unlock();
    }

    public boolean tryAcquireDrawingSemaphore() {
        return this.drawingSemaphore.tryLock();
    }

    private void validateAndUpdateZone(final Zone zone) {
        if (zone.isUpdate()) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    zone.validate();
                    GameLoop.get().runOnce(new Runnable(){

                        @Override
                        public void run() {
                            if (!zone.getName().equals(StendhalClient.this.staticLayers.getAreaName())) {
                                return;
                            }
                            StendhalClient.this.staticLayers.setZone(zone);
                            for (ZoneChangeListener zoneChangeListener : StendhalClient.this.zoneChangeListeners) {
                                zoneChangeListener.onZoneUpdate(zone);
                            }
                        }
                    });
                }
            };
            thread.start();
        } else {
            zone.validate();
            this.staticLayers.setZone(zone);
            for (ZoneChangeListener zoneChangeListener : this.zoneChangeListeners) {
                zoneChangeListener.onZoneChangeCompleted(zone);
            }
        }
    }

    public void connect(String string, int n) throws IOException {
        String string2 = ClientGameConfiguration.get((String)"GAME_NAME").toLowerCase(Locale.ENGLISH);
        String string3 = ClientGameConfiguration.get((String)"DEFAULT_SERVER_WEB") + "/versioncheck/" + URLEncoder.encode(string2, "UTF-8") + "/" + URLEncoder.encode(string, "UTF-8") + "/" + URLEncoder.encode(Integer.toString(n), "UTF-8") + "/" + URLEncoder.encode(Version.getVersion(), "UTF-8");
        HttpClient httpClient = new HttpClient(string3);
        String string4 = httpClient.fetchFirstLine();
        if (string4 != null && string4.trim().length() > 0) {
            JOptionPane.showMessageDialog(this.splashScreen, new JLabel(string4), "Sprawdzanie wersji", 2);
        }
        super.connect(string, n);
    }

    public void send(RPAction rPAction) {
        String string = rPAction.get("type");
        if (StendhalClient.serverVersionAtLeast("0.99") && RPClass.getRPClass((String)string) != null) {
            rPAction.setRPClass(string);
            rPAction.remove("type");
        }
        super.send(rPAction);
    }

    public static boolean serverVersionAtLeast(String string) {
        String string2 = User.getServerRelease();
        return string2 == null || Version.compare(string2, string) >= 0;
    }

    public boolean keyIsPressed(int n) {
        return pressedStateKeys.contains(n);
    }

    public boolean directionKeyIsPressed() {
        return pressedStateKeys.contains(38) || pressedStateKeys.contains(40) || pressedStateKeys.contains(37) || pressedStateKeys.contains(39) || pressedStateKeys.contains(226) || pressedStateKeys.contains(227) || pressedStateKeys.contains(224) || pressedStateKeys.contains(225);
    }

    public void onKeyPressed(int n) {
        if (!pressedStateKeys.contains(n)) {
            pressedStateKeys.add(n);
        }
    }

    public void onKeyReleased(int n) {
        if (pressedStateKeys.contains(n)) {
            pressedStateKeys.removeAll(Collections.singleton(n));
        } else {
            logger.warn((Object)("Released key " + Integer.toString(n) + " was not found in pressedStateKeys list"));
        }
    }

    static {
        pressedStateKeys = new ArrayList<Integer>();
    }

    public static interface ZoneChangeListener {
        public void onZoneChange(Zone var1);

        public void onZoneChangeCompleted(Zone var1);

        public void onZoneUpdate(Zone var1);
    }

    private static final class FaceRPAction
    extends RPAction {
        private FaceRPAction(Direction direction) {
            this.put("type", "face");
            this.put("dir", direction.get());
        }
    }

    private static final class MoveRPAction
    extends RPAction {
        private MoveRPAction(Direction direction) {
            this.put("type", "move");
            this.put("dir", direction.get());
        }
    }
}

