/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.MemoryCache;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.FlippedSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.SpriteTileset;
import games.stendhal.client.sprite.Tileset;
import games.stendhal.client.sprite.TilesetAnimationMap;
import games.stendhal.client.sprite.TilesetGroupAnimationMap;
import games.stendhal.client.util.JSONLoader;
import games.stendhal.common.tiled.TileSetDefinition;
import java.awt.Color;
import java.awt.Composite;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.Serializable;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

class TileStore
implements Tileset {
    private static final int TILE_FLIP_MASK = -536870912;
    private static final int TILE_ID_MASK = 0x1FFFFFFF;
    private static final Logger logger = Logger.getLogger(TileStore.class);
    private static final String baseFolder = "data/maps/";
    private static TilesetGroupAnimationMap landscapeAnimationMap;
    private static TilesetGroupAnimationMap weatherAnimationMap;
    private static final MemoryCache<String, Tileset> tilesetsLoaded;
    private final SpriteStore store;
    private final ArrayList<Sprite> tiles;
    private final List<TileSetDefinition> tilesets = new ArrayList<TileSetDefinition>();
    private boolean validated;

    public static TilesetGroupAnimationMap getLandscapeAnimationMap() {
        return landscapeAnimationMap;
    }

    public static TilesetGroupAnimationMap getWeatherAnimationMap() {
        return weatherAnimationMap;
    }

    public TileStore() {
        this(SpriteStore.get());
    }

    private TileStore(SpriteStore spriteStore) {
        this.store = spriteStore;
        this.tiles = new ArrayList();
        this.tiles.add(spriteStore.getEmptySprite());
    }

    public static void init() {
        if (landscapeAnimationMap != null && weatherAnimationMap != null) {
            logger.warn((Object)"tried to re-initialize TileStore");
            return;
        }
        final JSONLoader jSONLoader = new JSONLoader();
        jSONLoader.onDataReady = new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject = (JSONObject)jSONLoader.data;
                if (jSONObject.containsKey((Object)"landscape")) {
                    landscapeAnimationMap = TileStore.loadAnimations(TileStore.checkMap(jSONObject.get((Object)"landscape")), "tileset/");
                }
                if (jSONObject.containsKey((Object)"weather")) {
                    weatherAnimationMap = TileStore.loadAnimations(TileStore.checkMap(jSONObject.get((Object)"weather")), "data/sprites/weather/");
                }
            }
        };
        jSONLoader.load("data/maps/tileset/animation.json");
    }

    private static Map<String, List<String>> checkMap(Object object) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string = (String)entry.getKey();
                LinkedList<String> linkedList = new LinkedList<String>();
                Object v = entry.getValue();
                if (v instanceof List) {
                    for (Object e : (List)v) {
                        linkedList.add((String)e);
                    }
                }
                hashMap.put(string, linkedList);
            }
        }
        return hashMap;
    }

    private void add(TileSetDefinition tileSetDefinition, Color color, Composite composite) {
        String string;
        Tileset tileset;
        int n;
        int n2;
        String string2 = tileSetDefinition.getSource();
        int n3 = tileSetDefinition.getFirstGid();
        if (string2.startsWith("../../")) {
            string2 = string2.substring(6);
        }
        if ((n2 = this.tiles.size()) > n3) {
            logger.debug((Object)("Tileset base index mismatch (" + n2 + " > " + n3 + "): " + string2));
            for (n = n3; n < n2; ++n) {
                this.tiles.remove(n3);
            }
        } else if (n2 < n3) {
            logger.debug((Object)("Tileset base index mismatch (" + n2 + " < " + n3 + "): " + string2));
            for (n = n2; n < n3; ++n) {
                this.tiles.add(null);
            }
        }
        if ((tileset = tilesetsLoaded.get(string = color != null && composite != null ? this.store.createModifiedRef(string2, color, composite) : string2)) == null) {
            tileset = new SpriteTileset(this.store, baseFolder + string2, color, composite);
            tilesetsLoaded.put(string, tileset);
        }
        int n4 = tileset.getSize();
        this.tiles.ensureCapacity(n3 + n4);
        for (int i = 0; i < n4; ++i) {
            this.tiles.add(tileset.getSprite(i));
        }
        TilesetAnimationMap tilesetAnimationMap = landscapeAnimationMap.get(string2);
        if (tilesetAnimationMap != null) {
            for (int i = 0; i < n4; ++i) {
                Sprite sprite = tilesetAnimationMap.getSprite(tileset, i);
                if (sprite == null) continue;
                this.tiles.set(n3 + i, sprite);
            }
        }
    }

    void addTilesets(InputSerializer inputSerializer) throws IOException, ClassNotFoundException {
        int n = inputSerializer.readInt();
        for (int i = 0; i < n; ++i) {
            TileSetDefinition tileSetDefinition = (TileSetDefinition)inputSerializer.readObject((Serializable)new TileSetDefinition(null, null, -1));
            this.tilesets.add(tileSetDefinition);
        }
    }

    boolean validate(Color color, Composite composite) {
        if (!this.validated) {
            if (!this.tilesets.isEmpty()) {
                for (TileSetDefinition tileSetDefinition : this.tilesets) {
                    this.add(tileSetDefinition, color, composite);
                }
                this.tilesets.clear();
                this.validated = true;
                return true;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    private static TilesetGroupAnimationMap createAnimationMap() {
        TilesetGroupAnimationMap tilesetGroupAnimationMap = new TilesetGroupAnimationMap();
        URL uRL = DataLoader.getResource("data/maps/tileset/animation.seq");
        if (uRL != null) {
            try (InputStream inputStream = uRL.openStream();){
                tilesetGroupAnimationMap.load(inputStream);
            }
            catch (IOException iOException) {
                logger.error((Object)"Error loading tileset animation map", (Throwable)iOException);
            }
        }
        return tilesetGroupAnimationMap;
    }

    private static TilesetGroupAnimationMap loadAnimations(Map<String, List<String>> map, String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> list2 : map.entrySet()) {
            hashMap.put(list2.getKey(), list2.getValue());
        }
        TilesetGroupAnimationMap tilesetGroupAnimationMap = new TilesetGroupAnimationMap();
        List<String> list = TileStore.formatLines(hashMap, string);
        if (list.size() > 0) {
            tilesetGroupAnimationMap.load(list);
        }
        return tilesetGroupAnimationMap;
    }

    @Deprecated
    private static Map<String, List<String>> loadAnimations(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        URL uRL = DataLoader.getResource("data/maps/tileset/animation.json");
        if (uRL != null) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), StandardCharsets.UTF_8);
                JSONObject jSONObject = (JSONObject)JSONValue.parse((Reader)inputStreamReader);
                if (jSONObject == null) {
                    logger.error((Object)"failed to read animations file: data/maps/tileset/animation.json");
                    return null;
                }
                if (jSONObject.containsKey((Object)string)) {
                    for (Map.Entry<String, List<String>> entry : TileStore.checkMap(jSONObject.get((Object)string)).entrySet()) {
                        hashMap.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (IOException iOException) {
                logger.error((Object)("Error loading tileset animation map key: " + string), (Throwable)iOException);
            }
        }
        return hashMap;
    }

    private static List<String> formatLines(Map<String, List<String>> map, String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String string2 : entry.getValue()) {
                linkedList.add(string + entry.getKey() + ".png " + string2);
            }
        }
        return linkedList;
    }

    @Deprecated
    private static TilesetGroupAnimationMap createAnimationMap(String string, String string2) {
        List<String> list;
        TilesetGroupAnimationMap tilesetGroupAnimationMap = new TilesetGroupAnimationMap();
        Map<String, List<String>> map = TileStore.loadAnimations(string);
        if (map != null && (list = TileStore.formatLines(map, string2)).size() > 0) {
            tilesetGroupAnimationMap.load(list);
        }
        return tilesetGroupAnimationMap;
    }

    @Override
    public int getSize() {
        return this.tiles.size();
    }

    @Override
    public Sprite getSprite(int n) {
        int n2 = n & 0xE0000000;
        if ((n &= 0x1FFFFFFF) >= this.tiles.size()) {
            logger.error((Object)("Accessing unassigned sprite at: " + n));
            return this.store.getEmptySprite();
        }
        Sprite sprite = this.tiles.get(n);
        if (sprite == null) {
            logger.error((Object)("Accessing unassigned sprite at: " + n));
            return this.store.getEmptySprite();
        }
        if (n2 != 0) {
            sprite = new FlippedSprite(sprite, n2);
        }
        return sprite;
    }

    static {
        tilesetsLoaded = new MemoryCache();
    }
}

