/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.listener.FeatureChangeListener;
import games.stendhal.client.listener.RPObjectChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public class UserContext
implements RPObjectChangeListener {
    private static final Logger logger = Logger.getLogger(UserContext.class);
    private static final UserContext instance = new UserContext();
    private final HashMap<String, String> features = new HashMap();
    private final List<FeatureChangeListener> featureListeners = new CopyOnWriteArrayList<FeatureChangeListener>();
    private int adminlevel;
    private String name;
    private int sheepID;
    private int goatID;
    private volatile RPObject player;

    private UserContext() {
    }

    public static UserContext get() {
        return instance;
    }

    public void addFeatureChangeListener(FeatureChangeListener featureChangeListener) {
        this.featureListeners.add(featureChangeListener);
    }

    private void fireFeatureDisabled(String string) {
        logger.debug((Object)("Feature disabled: " + string));
        for (FeatureChangeListener featureChangeListener : this.featureListeners) {
            featureChangeListener.featureDisabled(string);
        }
    }

    private void fireFeatureEnabled(String string, String string2) {
        logger.debug((Object)("Feature enabled: " + string + " = " + string2));
        for (FeatureChangeListener featureChangeListener : this.featureListeners) {
            featureChangeListener.featureEnabled(string, string2);
        }
    }

    public int getAdminLevel() {
        return this.adminlevel;
    }

    public String getName() {
        return this.name;
    }

    public int getSheepID() {
        return this.sheepID;
    }

    public int getGoatID() {
        return this.goatID;
    }

    public boolean isAdmin() {
        return this.getAdminLevel() != 0;
    }

    void removeFeatureChangeListener(FeatureChangeListener featureChangeListener) {
        this.featureListeners.remove(featureChangeListener);
    }

    private void processFeaturesAdded(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (this.features.containsKey(entry.getKey()) && this.features.get(entry.getKey()).equals(entry.getValue())) continue;
            this.features.put(entry.getKey(), entry.getValue());
            this.fireFeatureEnabled(entry.getKey(), entry.getValue());
        }
    }

    private void processFeaturesRemoved(Map<String, String> map) {
        for (String string : map.keySet()) {
            if (!this.features.containsKey(string)) continue;
            this.features.remove(string);
            this.fireFeatureDisabled(string);
        }
    }

    public RPObject getPlayer() {
        return this.player;
    }

    protected void setPlayer(RPObject rPObject) {
        if (this.player != rPObject) {
            this.player = rPObject;
            this.name = rPObject.get("name");
        }
    }

    boolean isUser(RPObject rPObject) {
        if (this.name == null) {
            return false;
        }
        if (rPObject.getRPClass().subclassOf("player")) {
            return this.name.equalsIgnoreCase(rPObject.get("name"));
        }
        return false;
    }

    @Override
    public void onAdded(RPObject rPObject) {
        if (this.isUser(rPObject) && rPObject.has("adminlevel")) {
            this.adminlevel = rPObject.getInt("adminlevel");
        }
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        if (this.isUser(rPObject)) {
            if (rPObject2.has("adminlevel")) {
                this.adminlevel = rPObject2.getInt("adminlevel");
            }
            if (rPObject2.has("name")) {
                this.name = rPObject2.get("name");
            }
            if (rPObject2.has("sheep")) {
                this.sheepID = rPObject2.getInt("sheep");
            }
            if (rPObject2.has("goat")) {
                this.goatID = rPObject2.getInt("goat");
            }
            if (rPObject2.hasMap("features")) {
                this.processFeaturesAdded(rPObject2.getMap("features"));
            }
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        if (this.isUser(rPObject)) {
            if (rPObject2.has("adminlevel")) {
                this.adminlevel = 0;
            }
            if (rPObject2.has("name")) {
                this.name = null;
            }
            if (rPObject2.has("sheep")) {
                this.sheepID = 0;
            }
            if (rPObject2.has("goat")) {
                this.goatID = 0;
            }
            if (rPObject2.hasMap("features")) {
                this.processFeaturesRemoved(rPObject2.getMap("features"));
            }
        }
    }

    @Override
    public void onRemoved(RPObject rPObject) {
        if (this.isUser(rPObject)) {
            this.adminlevel = 0;
            this.name = null;
            this.sheepID = 0;
            this.goatID = 0;
        }
    }

    @Override
    public void onSlotAdded(RPObject rPObject, String string, RPObject rPObject2) {
    }

    @Override
    public void onSlotChangedAdded(RPObject rPObject, String string, RPObject rPObject2, RPObject rPObject3) {
    }

    @Override
    public void onSlotChangedRemoved(RPObject rPObject, String string, RPObject rPObject2, RPObject rPObject3) {
    }

    @Override
    public void onSlotRemoved(RPObject rPObject, String string, RPObject rPObject2) {
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean hasFeature(String string) {
        return this.features.get(string) != null;
    }
}

