/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.LayerRenderer;
import games.stendhal.client.TileStore;
import games.stendhal.client.sprite.EmptySprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.SpriteTileset;
import games.stendhal.client.sprite.Tileset;
import games.stendhal.client.sprite.TilesetGroupAnimationMap;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import org.apache.log4j.Logger;

public class WeatherLayerRenderer
extends LayerRenderer {
    private static final Logger logger = Logger.getLogger(WeatherLayerRenderer.class);
    private final Sprite weather;
    private final String name;
    private boolean reported = false;

    public WeatherLayerRenderer(String string, Color color, Composite composite) {
        Sprite sprite;
        SpriteStore spriteStore = SpriteStore.get();
        this.name = "data/sprites/weather/" + string + ".png";
        if (spriteStore.getSprite(this.name) == spriteStore.getFailsafe()) {
            sprite = new EmptySprite(1024, 1024, null);
            logger.warn((Object)("Weather sprite not found:" + this.name));
        } else {
            sprite = spriteStore.getModifiedSprite(this.name, color, composite);
        }
        SpriteTileset spriteTileset = new SpriteTileset(spriteStore, sprite, sprite.getHeight());
        TilesetGroupAnimationMap tilesetGroupAnimationMap = TileStore.getWeatherAnimationMap();
        this.weather = tilesetGroupAnimationMap != null && tilesetGroupAnimationMap.get(this.name) != null ? tilesetGroupAnimationMap.get(this.name).getSprite(spriteTileset, 0) : spriteTileset.getSprite(0);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        block4: {
            try {
                int n5 = n * 32 / this.weather.getWidth();
                int n6 = n2 * 32 / this.weather.getHeight();
                int n7 = n3 * 32 / this.weather.getWidth() + 1;
                int n8 = n4 * 32 / this.weather.getHeight() + 1;
                int n9 = n6 * this.weather.getHeight();
                for (int i = n6; i < n6 + n8; ++i) {
                    int n10 = n5 * this.weather.getWidth();
                    for (int j = n5; j < n5 + n7; ++j) {
                        this.weather.draw(graphics, n10, n9);
                        n10 += this.weather.getWidth();
                    }
                    n9 += this.weather.getHeight();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.reported) break block4;
                logger.error((Object)("Failed to draw weather: " + this.name), (Throwable)nullPointerException);
                this.reported = true;
            }
        }
    }

    @Override
    public void setTileset(Tileset tileset) {
        throw new UnsupportedOperationException("Adding tilesets not supported");
    }
}

