/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.CompositeLayerRenderer;
import games.stendhal.client.EmptyLayerRenderer;
import games.stendhal.client.LayerRenderer;
import games.stendhal.client.TileRenderer;
import games.stendhal.client.TileStore;
import games.stendhal.client.WeatherLayerRenderer;
import games.stendhal.client.ZoneInfo;
import games.stendhal.client.gui.j2d.Blend;
import games.stendhal.client.gui.wt.core.SettingChangeAdapter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.Tileset;
import games.stendhal.common.CollisionDetection;
import games.stendhal.common.MathHelper;
import games.stendhal.common.tiled.LayerDefinition;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import marauroa.common.game.RPObject;
import marauroa.common.net.InputSerializer;
import org.apache.log4j.Logger;

public class Zone {
    private static final Logger LOGGER = Logger.getLogger(Zone.class);
    private static final String WEATHER_PROPERTY = "ui.draw_weather";
    private final String name;
    private String readableName;
    private final Map<String, LayerRenderer> layers = new HashMap<String, LayerRenderer>();
    private final ZoneInfo zoneInfo = ZoneInfo.get();
    private LayerRenderer weather = new EmptyLayerRenderer();
    private String weatherName;
    private CollisionDetection collision;
    private CollisionDetection protection;
    private CollisionDetection secret;
    private TileStore tileset;
    private volatile boolean isValid;
    private boolean requireData;
    private boolean update;
    private double dangerLevel;
    private boolean drawWeather;

    Zone(String string) {
        this.name = string;
        WtWindowManager.getInstance().registerSettingChangeListener(WEATHER_PROPERTY, new SettingChangeAdapter(WEATHER_PROPERTY, "true"){

            @Override
            public void changed(String string) {
                boolean bl = Boolean.parseBoolean(string);
                if (Zone.this.drawWeather != bl) {
                    Zone.this.drawWeather = bl;
                    if (!bl) {
                        Zone.this.weather = new EmptyLayerRenderer();
                    } else if (Zone.this.weatherName != null) {
                        Zone.this.weather = new WeatherLayerRenderer(Zone.this.weatherName, Zone.this.zoneInfo.getZoneColor(), Zone.this.zoneInfo.getColorMethod());
                    }
                }
            }
        });
    }

    boolean isUpdate() {
        return this.update;
    }

    void setUpdate(boolean bl) {
        this.update = bl;
    }

    void requireDataLayer() {
        this.requireData = true;
    }

    void addLayer(String string, InputStream inputStream) throws IOException, ClassNotFoundException {
        if (string.equals("collision")) {
            this.collision = new CollisionDetection();
            this.collision.setCollisionData(LayerDefinition.decode(inputStream));
        } else if (string.equals("protection")) {
            this.protection = new CollisionDetection();
            this.protection.setCollisionData(LayerDefinition.decode(inputStream));
        } else if (string.equals("secret")) {
            this.secret = new CollisionDetection();
            this.secret.setCollisionData(LayerDefinition.decode(inputStream));
        } else if (string.equals("tilesets")) {
            TileStore tileStore = new TileStore();
            tileStore.addTilesets(new InputSerializer(inputStream));
            this.tileset = tileStore;
        } else if (string.equals("data_map")) {
            this.readDataLayer(inputStream);
        } else {
            TileRenderer tileRenderer = new TileRenderer();
            tileRenderer.setMapData(inputStream);
            this.layers.put(string, tileRenderer);
        }
        this.isValid = false;
    }

    private void readDataLayer(InputStream inputStream) throws IOException {
        String string;
        RPObject rPObject = new RPObject();
        rPObject.readObject(new InputSerializer(inputStream));
        this.zoneInfo.setColorMethod(null);
        String string2 = rPObject.get("color");
        if (string2 != null && this.isColoringEnabled()) {
            this.zoneInfo.setZoneColor(MathHelper.parseIntDefault(string2, 65280));
            this.zoneInfo.setColorMethod(this.getBlend(rPObject.get("color_method")));
        }
        if (this.isColoringEnabled()) {
            this.zoneInfo.setEffectBlend(this.getEffectBlend(rPObject.get("blend_method"), this.zoneInfo.getColorMethod()));
        } else {
            this.zoneInfo.setEffectBlend(null);
        }
        String string3 = rPObject.get("weather");
        if (string3 != null) {
            this.weatherName = string3;
            if (this.drawWeather) {
                this.weather = new WeatherLayerRenderer(string3, this.zoneInfo.getZoneColor(), this.zoneInfo.getColorMethod());
            }
        }
        if ((string = rPObject.get("danger_level")) != null) {
            try {
                this.dangerLevel = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(Zone.class).warn((Object)("Invalid danger level: " + string), (Throwable)numberFormatException);
            }
        }
        this.readableName = rPObject.get("readable_name");
        String string4 = rPObject.get("music");
        float f = 1.0f;
        String string5 = rPObject.get("music_volume");
        try {
            if (string5 != null) {
                f = Float.parseFloat(string5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(Zone.class).warn((Object)("Invalid volume level: " + string5), (Throwable)numberFormatException);
        }
        this.zoneInfo.setSingleGlobalizedMusic(string4, f);
        this.requireData = false;
    }

    private boolean isColoringEnabled() {
        return WtWindowManager.getInstance().getPropertyBoolean("ui.colormaps", true);
    }

    private Composite getEffectBlend(String string, Composite composite) {
        if ("bleach".equals(string) && composite != Blend.Multiply) {
            string = "generic_light";
        }
        return this.getBlend(string);
    }

    private Composite getBlend(String string) {
        if ("bleach".equals(string)) {
            if (this.zoneInfo.getZoneColor() != null) {
                return Blend.createBleach(this.zoneInfo.getZoneColor());
            }
        } else {
            if ("generic_light".equals(string)) {
                return Blend.GenericLight;
            }
            if ("multiply".equals(string)) {
                return Blend.Multiply;
            }
            if ("screen".equals(string)) {
                return Blend.Screen;
            }
            if ("softlight".equals(string)) {
                return Blend.SoftLight;
            }
            if ("truecolor".equals(string)) {
                return Blend.TrueColor;
            }
            if (string != null) {
                LOGGER.warn((Object)("Unknown blend mode: '" + string + "'"));
            }
        }
        return null;
    }

    String getName() {
        return this.name;
    }

    public String getReadableName() {
        if (this.readableName != null) {
            return this.readableName;
        }
        return this.name;
    }

    double getWidth() {
        if (!this.isValid) {
            return 0.0;
        }
        return this.collision.getWidth();
    }

    double getHeight() {
        if (!this.isValid) {
            return 0.0;
        }
        return this.collision.getHeight();
    }

    public double getDangerLevel() {
        return this.dangerLevel;
    }

    boolean collides(Rectangle2D rectangle2D) {
        if (this.collision != null) {
            return this.collision.collides(rectangle2D);
        }
        return false;
    }

    public CollisionDetection getCollision() {
        return this.collision;
    }

    public CollisionDetection getProtection() {
        return this.protection;
    }

    public CollisionDetection getSecret() {
        return this.secret;
    }

    /*
     * WARNING - void declaration
     */
    LayerRenderer getMerged(String string, String string2, String ... stringArray) {
        LayerRenderer layerRenderer = this.layers.get(string);
        if (layerRenderer == null) {
            void var8_12;
            LayerRenderer layerRenderer2;
            ArrayList<TileRenderer> arrayList = new ArrayList<TileRenderer>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                layerRenderer2 = this.layers.get(stringArray[i]);
                if (layerRenderer2 instanceof TileRenderer) {
                    arrayList.add((TileRenderer)layerRenderer2);
                    continue;
                }
                if (layerRenderer2 == null) continue;
                return null;
            }
            if (arrayList.isEmpty()) {
                return new EmptyGroupRenderer();
            }
            TileRenderer tileRenderer = null;
            layerRenderer2 = this.layers.get(string2);
            if (layerRenderer2 instanceof TileRenderer) {
                tileRenderer = (TileRenderer)layerRenderer2;
            }
            if (!this.isValid) {
                return null;
            }
            for (String string3 : stringArray) {
                this.layers.remove(string3);
            }
            this.layers.remove(string2);
            Composite composite = this.zoneInfo.getEffectBlend();
            if (tileRenderer == null) {
                Object var8_11 = null;
            }
            if (var8_12 == null) {
                tileRenderer = null;
            }
            layerRenderer = new CompositeLayerRenderer(arrayList, (Composite)var8_12, tileRenderer);
            this.layers.put(string, layerRenderer);
        }
        return layerRenderer;
    }

    LayerRenderer getWeather() {
        return this.weather;
    }

    String getWeatherName() {
        return this.weatherName;
    }

    boolean validate() {
        if (this.isValid) {
            return true;
        }
        if (this.tileset == null || this.requireData) {
            return false;
        }
        if (this.collision == null) {
            return false;
        }
        if (!this.tileset.validate(this.zoneInfo.getZoneColor(), this.zoneInfo.getColorMethod())) {
            return false;
        }
        for (LayerRenderer layerRenderer : this.layers.values()) {
            layerRenderer.setTileset(this.tileset);
        }
        this.isValid = true;
        return true;
    }

    private static class EmptyGroupRenderer
    extends LayerRenderer {
        private EmptyGroupRenderer() {
        }

        @Override
        public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        }

        @Override
        public void setTileset(Tileset tileset) {
        }
    }
}

