/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import java.util.Locale;
import marauroa.common.game.Definition;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;

public enum ActionType {
    LOOK("look", "Zobacz"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    READ("look", "Przeczytaj"),
    LOOK_CLOSELY("use", "Przyjrzyj si\u0119 dok\u0142adnie"),
    INSPECT("inspect", "Przeszukaj"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    ATTACK("attack", "Atakuj"),
    STOP_ATTACK("stop", "Przerwij atak"),
    PUSH("push", "Popchnij"),
    CLOSE("use", "Zamknij"),
    OPEN("use", "Otw\u00f3rz"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    OWN("own", "Przygarnij"),
    USE("use", "U\u017cyj"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    HARVEST("use", "Zbierz"),
    PICK("use", "Podnie\u015b"),
    PROSPECT("use", "Poszukaj z\u0142ota"),
    STONE("use", "Wydob\u0105d\u017a"),
    FISH("use", "Z\u0142\u00f3w ryb\u0119"),
    WISH("use", "Pomy\u015bl \u017cyczenie"),
    WOOD("use", "Zetnij"),
    LEAVE_SHEEP("forsake", "Zostaw owc\u0119"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("species", "sheep");
            return rPAction;
        }
    }
    ,
    LEAVE_GOAT("forsake", "Zostaw koz\u0119"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("species", "goat");
            return rPAction;
        }
    }
    ,
    LEAVE_PET("forsake", "Zostaw zwierz\u0105tko"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("species", "pet");
            return rPAction;
        }
    }
    ,
    ADD_BUDDY("addbuddy", "Dodaj do Przyjaci\u00f3\u0142"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    IGNORE("ignore", "Ignoruj"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    UNIGNORE("unignore", "Usu\u0144 ignorowanie"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    TRADE("trade", "Handluj"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("action", "offer_trade");
            return rPAction;
        }
    }
    ,
    ADMIN_INSPECT("inspect", "(*)Zbadaj (inspect)"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    ADMIN_GAG("gag", "(*)Ucisz (gag)"),
    ADMIN_JAIL("jail", "(*)Aresztuj (jail)"),
    ADMIN_DESTROY("destroy", "(*)Zniszcz (destroy)"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    ADMIN_ALTER("alter", "(*)Zmie\u0144 (alter)"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            return this.fillTargetPath(super.fillTargetInfo(iEntity), iEntity);
        }
    }
    ,
    SET_OUTFIT("outfit_ext", "Ustaw wygl\u0105d"),
    WHERE("where", "Gdzie"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    ADMIN_VIEW_NPC_TRANSITIONS("npctransitions", "(*)Poka\u017c przej\u015bcia"),
    KNOCK("knock", "Zapukaj"),
    INVITE("group_management", "Zapro\u015b"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("action", "invite");
            rPAction.put("params", iEntity.getName());
            return rPAction;
        }
    }
    ,
    WALK_START("walk", "Ch\u00f3d\u017a"),
    WALK_STOP("walk", "St\u00f3j"),
    CHALLENGE("challenge", "Wyzwanie"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("type", "challenge");
            rPAction.put("action", "open");
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    ACCEPT_CHALLENGE("challenge", "Zaakceptuj"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("type", "challenge");
            rPAction.put("action", "accept");
            rPAction.put("target", iEntity.getName());
            return rPAction;
        }
    }
    ,
    MARK_ALL("markscroll", "Zapisz wszystkie"){

        @Override
        public RPAction fillTargetInfo(IEntity iEntity) {
            RPAction rPAction = super.fillTargetInfo(iEntity);
            rPAction.put("type", "markscroll");
            rPAction.put("quantity", iEntity.getRPObject().get("quantity"));
            return rPAction;
        }
    };

    private final String actionCode;
    private final String actionRepresentation;

    private ActionType(String string2, String string3) {
        this.actionCode = string2;
        this.actionRepresentation = string3;
    }

    public static ActionType getbyRep(String string) {
        for (ActionType actionType : ActionType.values()) {
            if (!actionType.actionRepresentation.toLowerCase(Locale.ENGLISH).equals(string.toLowerCase(Locale.ENGLISH))) continue;
            return actionType;
        }
        return null;
    }

    public String toString() {
        return this.actionCode;
    }

    public String getRepresentation() {
        return this.actionRepresentation;
    }

    public void send(RPAction rPAction) {
        StendhalClient.get().send(rPAction);
    }

    public RPAction fillTargetInfo(IEntity iEntity) {
        RPAction rPAction = new RPAction();
        RPClass rPClass = RPClass.getRPClass((String)this.actionCode);
        boolean bl = true;
        if (rPClass != null) {
            rPAction.setRPClass(this.actionCode);
            if (rPClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, "zone") == null) {
                bl = false;
            }
        } else {
            rPAction.put("type", this.toString());
        }
        RPObject rPObject = iEntity.getRPObject();
        int n = rPObject.getID().getObjectID();
        if (bl) {
            rPAction.put("zone", iEntity.getRPObject().getBaseContainer().get("zoneid"));
        }
        if (rPObject.isContained()) {
            rPAction.put("baseobject", rPObject.getContainer().getID().getObjectID());
            rPAction.put("baseslot", rPObject.getContainerSlot().getName());
            rPAction.put("baseitem", n);
        } else {
            StringBuilder stringBuilder = new StringBuilder("#");
            stringBuilder.append(Integer.toString(n));
            rPAction.put("target", stringBuilder.toString());
        }
        return rPAction;
    }

    RPAction fillTargetPath(RPAction rPAction, IEntity iEntity) {
        rPAction.put("target_path", iEntity.getPath());
        return rPAction;
    }

    public String getActionCode() {
        return this.actionCode;
    }
}

