/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameLoop;
import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.AudibleEntity;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Property;
import games.stendhal.client.entity.StatusID;
import games.stendhal.client.entity.TextIndicator;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.chatlog.EmojiEventLine;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.chatlog.StandardEventLine;
import games.stendhal.client.gui.chatlog.StandardHeaderedEventLine;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.EmojiStore;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.common.ItemTools;
import games.stendhal.common.NotificationType;
import games.stendhal.common.constants.Nature;
import games.stendhal.common.constants.SoundLayer;
import games.stendhal.common.grammar.Grammar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public abstract class RPEntity
extends AudibleEntity {
    private static final Logger LOGGER = Logger.getLogger(RPEntity.class);
    private static final int HEARING_DISTANCE_SQ = 225;
    private static final int TURN_LENGTH = 300;
    private static final int BUBBLE_TEXT_LENGTH = 124;
    public static final Property PROP_ADMIN_LEVEL = new Property();
    public static final Property PROP_GHOSTMODE = new Property();
    public static final Property PROP_GROUP_MEMBERSHIP = new Property();
    public static final Property PROP_TEXT_INDICATORS = new Property();
    public static final Property PROP_OUTFIT = new Property();
    public static final Property PROP_TITLE_TYPE = new Property();
    public static final Property PROP_HP_RATIO = new Property();
    public static final Property PROP_HP_DISPLAY = new Property();
    public static final Property PROP_HEALER = new Property();
    public static final Property PROP_MERCHANT = new Property();
    public static final Property PROP_PRODUCER = new Property();
    public static final Property PROP_CONFUSED = new Property();
    public static final Property PROP_EATING = new Property();
    public static final Property PROP_POISONED = new Property();
    public static final Property PROP_BLEEDING = new Property();
    public static final Property PROP_SHOCK = new Property();
    public static final Property PROP_ZOMBIE = new Property();
    public static final Property PROP_HEAVY = new Property();
    private static final Map<StatusID, Property> statusProp = new EnumMap<StatusID, Property>(StatusID.class);
    public static final Property PROP_ATTACK;
    public static final int OUTFIT_UNSET = -1;
    RPEntity attackTarget = null;
    private final Collection<Entity> attackers = new ConcurrentLinkedQueue<Entity>();
    private Nature attackNature;
    private String weapon;
    private boolean isDoingRangedAttack;
    private boolean targetUpdated;
    private int atk;
    private int def;
    private int ratk;
    private int mining;
    private int xp;
    private int hp;
    private int adminlevel;
    private String outfit_ext;
    private int outfit_old;
    private String gender;
    private int baseHP;
    private float hpRatio;
    private int level;
    private boolean eating;
    private final Set<StatusID> statuses = EnumSet.noneOf(StatusID.class);
    private boolean choking;
    private boolean showTitle = true;
    private boolean showHP = true;
    private volatile long combatIconTime;
    private final List<TextIndicator> textIndicators = new LinkedList<TextIndicator>();
    private RPObject.ID attacking;
    private int mana;
    private int baseMana;
    private boolean ghostmode;
    private boolean ignoreCollision;
    private String titleType;
    private volatile Resolution resolution;
    private int atkXP;
    private int defXP;
    private int ratkXP;
    private int miningXP;
    private int atkItem = -1;
    private int defItem = -1;
    private int ratkItem = -1;
    private double capacity;
    private double baseCapacity;
    private boolean released;
    private boolean castShadow = true;
    private String shadowStyle;
    private boolean isImmortal = false;

    RPEntity() {
    }

    protected void addTextIndicator(String string, NotificationType notificationType) {
        this.textIndicators.add(new TextIndicator(string, notificationType));
        this.fireChange(PROP_TEXT_INDICATORS);
    }

    public int getAdminLevel() {
        return this.adminlevel;
    }

    public int getAtk() {
        return this.atk;
    }

    public int getAtkItem() {
        return this.atkItem;
    }

    public int getAtkXP() {
        return this.atkXP;
    }

    public int getBaseHP() {
        return this.baseHP;
    }

    public int getBaseMana() {
        return this.baseMana;
    }

    public double getBaseCapacity() {
        return this.baseCapacity;
    }

    public int getDef() {
        return this.def;
    }

    public int getDefItem() {
        return this.defItem;
    }

    public int getDefXP() {
        return this.defXP;
    }

    public int getRatk() {
        return this.ratk;
    }

    public int getRatkItem() {
        return this.ratkItem;
    }

    public int getRatkXP() {
        return this.ratkXP;
    }

    public int getMining() {
        return this.mining;
    }

    public int getMiningXP() {
        return this.miningXP;
    }

    public float getHpRatio() {
        return this.hpRatio;
    }

    public Iterator<TextIndicator> getTextIndicators() {
        return this.textIndicators.iterator();
    }

    public String getGender() {
        return this.gender;
    }

    int getLevel() {
        return this.level;
    }

    public int getMana() {
        return this.mana;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public String getExtOutfit() {
        return this.outfit_ext;
    }

    public int getOldOutfitCode() {
        return this.outfit_old;
    }

    @Deprecated
    public int getOutfit() {
        return this.getOldOutfitCode();
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public RPEntity getAttackTarget() {
        return this.attackTarget;
    }

    private void setTarget(String string, String string2) {
        int n = Integer.parseInt(string);
        RPObject.ID iD = new RPObject.ID(n, string2);
        RPEntity rPEntity = (RPEntity)GameObjects.getInstance().get(iD);
        if (rPEntity != this.attackTarget) {
            this.onStopAttack();
            if (this.attackTarget != null) {
                this.attackTarget.onStopAttacked(this);
            }
            this.attackTarget = rPEntity;
            if (this.attackTarget != null) {
                this.onAttack(this.attackTarget);
                this.attackTarget.onAttacked(this);
            }
        }
    }

    private void setTarget(String string) {
        this.setTarget(string, this.rpObject.get("zoneid"));
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.name != null) {
            return this.name;
        }
        if (this.clazz != null) {
            return ItemTools.itemNameToDisplayName(this.clazz);
        }
        if (this.type != null) {
            return ItemTools.itemNameToDisplayName(this.type);
        }
        return null;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public int getXP() {
        return this.xp;
    }

    public Collection<Entity> getAttackers() {
        return this.attackers;
    }

    private RPObject.ID getTargetID() {
        if (!this.targetUpdated && this.attacking == null) {
            GameLoop.get().runOnce(new Runnable(){

                @Override
                public void run() {
                    String string;
                    if (RPEntity.this.attacking == null && !RPEntity.this.released && (string = RPEntity.this.rpObject.get("target")) != null) {
                        RPEntity.this.setTarget(string);
                    }
                }
            });
            this.targetUpdated = true;
        }
        return this.attacking;
    }

    public boolean isAttacking(IEntity iEntity) {
        if (iEntity == null) {
            return false;
        }
        RPObject.ID iD = iEntity.getID();
        return iD.equals((Object)this.getTargetID());
    }

    public boolean isBeingAttacked() {
        return !this.attackers.isEmpty();
    }

    public boolean isAttackedBy(IEntity iEntity) {
        return this.attackers.contains(iEntity);
    }

    public Nature getShownDamageType() {
        return this.attackNature;
    }

    public String getShownWeapon() {
        return this.weapon;
    }

    public boolean isDoingRangedAttack() {
        return this.isDoingRangedAttack;
    }

    public boolean isDefending() {
        return this.isBeingAttacked() && System.currentTimeMillis() - this.combatIconTime < 1200L;
    }

    public boolean isEating() {
        return this.eating;
    }

    public boolean isGhostMode() {
        return this.ghostmode;
    }

    public boolean ignoresCollision() {
        return this.ignoreCollision;
    }

    public boolean isConfused() {
        return this.hasStatus(StatusID.POISON) || this.hasStatus(StatusID.CONFUSE);
    }

    public boolean hasStatus(StatusID statusID) {
        return this.statuses.contains((Object)statusID);
    }

    public boolean isChoking() {
        return this.choking;
    }

    void nonCreatureClientAddEventLine(String string) {
        ClientSingletonRepository.getUserInterface().addEventLine(new StandardHeaderedEventLine(this.getTitle(), string));
    }

    void nonCreatureClientAddEmojiEventLine(String string) {
        ClientSingletonRepository.getUserInterface().addEventLine(new EmojiEventLine(this.getTitle(), string));
    }

    private void onAttack(IEntity iEntity) {
        this.attacking = iEntity.getID();
    }

    public void onAttackPerformed(Nature nature, boolean bl, String string) {
        this.attackNature = nature;
        this.isDoingRangedAttack = bl;
        this.weapon = string;
        this.fireChange(PROP_ATTACK);
    }

    private void onAttacked(Entity entity) {
        this.attackers.remove(entity);
        this.attackers.add(entity);
    }

    public void onBlocked() {
        this.resolution = Resolution.BLOCKED;
        this.combatIconTime = System.currentTimeMillis();
        this.playRandomSoundFromCategory(SoundLayer.FIGHTING_NOISE.groupName, "block");
    }

    public void onDamaged(Entity entity, int n) {
        boolean bl;
        this.resolution = Resolution.HIT;
        this.combatIconTime = System.currentTimeMillis();
        boolean bl2 = bl = this.isUser() || entity.isUser();
        if (bl &= false) {
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(this.getTitle() + " " + Grammar.genderVerb(this.getGender(), "otrzyma\u0142") + " " + Grammar.quantityplnoun(n, "punkt") + " obra\u017ce\u0144 od " + entity.getTitle(), NotificationType.NEGATIVE));
        }
        this.playRandomSoundFromCategory(SoundLayer.FIGHTING_NOISE.groupName, "attack");
    }

    private void setEatAndChoke(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (bl2 && this.eating != bl) {
            this.eating = bl;
            bl4 = true;
        }
        if (bl3 && this.choking != bl) {
            this.choking = bl;
            bl4 = true;
        }
        if (bl4) {
            this.fireChange(PROP_EATING);
        }
    }

    public void onHealed(int n) {
    }

    private void onHPChange(int n, boolean bl) {
        if (this.isInHearingRange()) {
            if (n > 0) {
                this.addTextIndicator("+" + n, NotificationType.POSITIVE);
            } else if (bl) {
                this.addTextIndicator("*" + String.valueOf(n) + "*", NotificationType.INFORMATION);
            } else {
                this.addTextIndicator(String.valueOf(n), NotificationType.NEGATIVE);
            }
        }
    }

    public void onMissed() {
        this.resolution = Resolution.MISSED;
        this.combatIconTime = System.currentTimeMillis();
    }

    private void onPoisoned(int n) {
        if (n > 0 && this.isInHearingRange()) {
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(this.getTitle() + " " + Grammar.genderVerb(this.getGender(), "zosta\u0142") + " " + Grammar.genderVerb(this.getGender(), "zatruty") + ". Traci " + Grammar.quantityplnoun(n, "punkt") + " \u017cycia.", NotificationType.POISON));
        }
    }

    private void setStatus(StatusID statusID, boolean bl) {
        if (bl) {
            this.statuses.add(statusID);
        } else {
            this.statuses.remove((Object)statusID);
        }
        this.fireChange(statusProp.get((Object)statusID));
    }

    public void onPrivateListen(String string, String string2) {
        NotificationType notificationType;
        try {
            notificationType = NotificationType.valueOf(string);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error((Object)"Unkown texttype: ", (Throwable)runtimeException);
            notificationType = NotificationType.PRIVMSG;
        }
        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string2, notificationType));
        if (notificationType != NotificationType.SCENE_SETTING) {
            ClientSingletonRepository.getScreenController().addText(this.getX() + this.getWidth() / 2.0, this.getY(), string2.replace("|", ""), notificationType, false);
        }
    }

    private void onStopAttack() {
        this.attacking = null;
    }

    private void onStopAttacked(IEntity iEntity) {
        this.attackers.remove(iEntity);
    }

    public void onReachAchievement(String string, String string2, String string3) {
        ClientSingletonRepository.getUserInterface().addAchievementBox(string, string2, string3);
    }

    public boolean isInHearingRange(int n) {
        return User.isAdmin() || User.squaredDistanceTo(this.x, this.y) < (double)n;
    }

    public boolean isInHearingRange() {
        return this.isInHearingRange(225);
    }

    public void onTalk(String string) {
        this.onTalk(string, 225);
    }

    public void onTalk(String string, int n) {
        if (User.isAdmin() || n < 0 || this.isInHearingRange(n)) {
            String string2 = this.trimText(string);
            EmojiStore emojiStore = ClientSingletonRepository.getEmojiStore();
            Sprite sprite = emojiStore.create(string2);
            if (string.startsWith("!me")) {
                string = string.replace("!me", this.getTitle());
                ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string, NotificationType.EMOTE));
                return;
            }
            if (sprite != null) {
                String string3 = emojiStore.absPath(string2);
                this.nonCreatureClientAddEmojiEventLine(string3);
            } else {
                this.nonCreatureClientAddEventLine(string);
            }
            if (sprite != null) {
                ClientSingletonRepository.getScreenController().addEmoji(this, sprite);
            } else if (!WtWindowManager.getInstance().getPropertyBoolean("ui.chat_bubbles", false)) {
                ClientSingletonRepository.getScreenController().addText(this.getX() + this.getWidth(), this.getY(), string2, NotificationType.NORMALBLACK, true);
            } else {
                ClientSingletonRepository.getScreenController().addText(this, string2, NotificationType.NORMALBLACK, true);
            }
        }
    }

    private String trimText(String string) {
        if (string.length() > 124) {
            string = string.substring(0, 124);
            int n = string.lastIndexOf(32);
            n = Math.max(n, string.lastIndexOf(45));
            n = Math.max(n, string.lastIndexOf(46));
            if ((n = Math.max(n, string.lastIndexOf(44))) > 0) {
                string = string.substring(0, n);
            }
            string = string + " ...";
        }
        return string;
    }

    @Override
    public int getResistance() {
        if (this.isGhostMode()) {
            return 0;
        }
        return super.getResistance();
    }

    @Override
    public void initialize(RPObject rPObject) {
        super.initialize(rPObject);
        this.baseHP = rPObject.has("base_hp") ? rPObject.getInt("base_hp") : 0;
        this.hp = rPObject.has("hp") ? rPObject.getInt("hp") : 0;
        this.hpRatio = this.hp >= this.baseHP ? 1.0f : (this.hp <= 0 ? 0.0f : (float)this.hp / (float)this.baseHP);
        if (rPObject.has("text")) {
            this.onTalk(rPObject.get("text"));
        }
        this.outfit_ext = rPObject.has("outfit_ext") ? rPObject.get("outfit_ext") : null;
        this.outfit_old = rPObject.has("outfit") ? rPObject.getInt("outfit") : -1;
        this.gender = rPObject.has("gender") ? rPObject.get("gender") : null;
        this.setEatAndChoke(true, rPObject.has("eating"), rPObject.has("choking"));
        for (StatusID statusID : StatusID.values()) {
            if (!rPObject.has(statusID.getAttribute())) continue;
            this.setStatus(statusID, true);
        }
        this.ghostmode = rPObject.has("ghostmode");
        this.ignoreCollision = rPObject.has("ignore_collision");
        if (rPObject.has("heal")) {
            this.onHealed(rPObject.getInt("heal"));
        }
        this.adminlevel = rPObject.has("adminlevel") ? rPObject.getInt("adminlevel") : 0;
        this.titleType = rPObject.get("title_type");
        this.showTitle = !rPObject.has("unnamed");
        boolean bl = this.showHP = !rPObject.has("no_hpbar");
        if (rPObject.has("immortal")) {
            this.isImmortal = true;
        }
        if (rPObject.has("no_shadow")) {
            this.castShadow = false;
        }
        this.shadowStyle = rPObject.get("shadow_style");
        this.initializeSounds();
    }

    private void initializeSounds() {
        this.addSounds(SoundLayer.FIGHTING_NOISE.groupName, "attack", "attack-melee-01", "attack-melee-02", "attack-melee-03", "attack-melee-04", "attack-melee-05", "attack-melee-06", "attack-range-01", "attack-swing-01", "attack-slap-01", "pol-attack-slash", "pol-attack-crash", "pol-attack-sword", "pol-attack-swing", "pol-attack-kling");
        this.addSounds(SoundLayer.FIGHTING_NOISE.groupName, "block", "clang-metallic-1", "clang-dull-1");
    }

    @Override
    public void release() {
        this.released = true;
        this.onStopAttack();
        if (this.attackTarget != null) {
            this.attackTarget.onStopAttacked(this);
            this.attackTarget = null;
        }
        super.release();
    }

    @Override
    public void update(int n) {
        super.update(n);
        if (!this.textIndicators.isEmpty()) {
            Iterator<TextIndicator> iterator = this.textIndicators.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                TextIndicator textIndicator = iterator.next();
                if ((long)textIndicator.addAge(n) <= 2000L) continue;
                iterator.remove();
                bl = true;
            }
            if (bl) {
                this.fireChange(PROP_TEXT_INDICATORS);
            }
        }
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        int n;
        super.onChangedAdded(rPObject, rPObject2);
        if (!this.inAdd) {
            String string;
            int n2;
            int n3;
            if (rPObject2.has("text")) {
                this.onTalk(rPObject2.get("text"));
            }
            if (rPObject2.has("outfit_ext") || rPObject2.has("outfit")) {
                if (rPObject2.has("outfit_ext")) {
                    this.outfit_ext = rPObject2.get("outfit_ext");
                    this.fireChange(PROP_OUTFIT);
                }
                if (rPObject2.has("outfit")) {
                    this.outfit_old = rPObject2.getInt("outfit");
                }
                this.fireChange(PROP_OUTFIT);
            }
            this.setEatAndChoke(true, rPObject2.has("eating"), rPObject2.has("choking"));
            for (StatusID statusID : StatusID.values()) {
                String string2 = statusID.getAttribute();
                if (!rPObject2.has(string2)) continue;
                this.setStatus(statusID, true);
                if (!string2.equals(StatusID.POISON.getAttribute())) continue;
                this.onPoisoned(Math.abs(rPObject2.getInt(string2)));
            }
            if (rPObject2.has("heal")) {
                this.onHealed(rPObject2.getInt("heal"));
            }
            n = 0;
            if (rPObject2.has("base_hp")) {
                this.baseHP = rPObject2.getInt("base_hp");
                n = 1;
            }
            if (rPObject2.has("modified_base_hp")) {
                this.baseHP = rPObject2.getInt("modified_base_hp");
                n = 1;
            }
            if (rPObject2.has("hp")) {
                n3 = rPObject2.getInt("hp");
                n2 = n3 - this.hp;
                boolean bl = rPObject2.has("crit");
                this.hp = n3;
                if (rPObject.has("hp") && n2 != 0) {
                    this.onHPChange(n2, bl);
                }
                n = 1;
            }
            if (rPObject2.has("modified_hp")) {
                n3 = rPObject2.getInt("modified_hp");
                n2 = n3 - this.hp;
                boolean bl = rPObject2.has("crit");
                this.hp = n3;
                if (rPObject.has("hp") && n2 != 0) {
                    this.onHPChange(n2, bl);
                }
                n = 1;
            }
            if (n != 0) {
                this.hpRatio = this.hp >= this.baseHP ? 1.0f : (this.hp <= 0 ? 0.0f : (float)this.hp / (float)this.baseHP);
                if (this.hp == 0) {
                    this.onDeath();
                }
                this.fireChange(PROP_HP_RATIO);
            }
            if (rPObject2.has("no_hpbar")) {
                this.showHP = false;
                this.fireChange(PROP_HP_DISPLAY);
            }
            if ((string = rPObject2.get("target")) != null) {
                this.setTarget(string, rPObject2.get("zoneid"));
            }
            if (rPObject2.has("adminlevel")) {
                this.adminlevel = rPObject2.getInt("adminlevel");
                this.fireChange(PROP_ADMIN_LEVEL);
            }
            if (rPObject2.has("title_type")) {
                this.titleType = rPObject2.get("title_type");
                this.fireChange(PROP_TITLE_TYPE);
            }
            if (rPObject2.has("class") || rPObject2.has("name") || rPObject2.has("title")) {
                this.fireChange(PROP_TITLE);
            }
            if (rPObject2.has("unnamed")) {
                this.showTitle = false;
                this.fireChange(PROP_TITLE);
            }
        }
        if (rPObject2.has("gender")) {
            this.gender = rPObject2.get("gender");
        }
        if (rPObject2.has("atk")) {
            this.atk = rPObject2.getInt("atk");
        }
        if (rPObject2.has("modified_atk")) {
            this.atk = rPObject2.getInt("modified_atk");
        }
        if (rPObject2.has("def")) {
            this.def = rPObject2.getInt("def");
        }
        if (rPObject2.has("modified_def")) {
            this.def = rPObject2.getInt("modified_def");
        }
        if (rPObject2.has("ratk")) {
            this.ratk = rPObject2.getInt("ratk");
        }
        if (rPObject2.has("modified_ratk")) {
            this.ratk = rPObject2.getInt("modified_ratk");
        }
        if (rPObject2.has("mining")) {
            this.mining = rPObject2.getInt("mining");
        }
        if (rPObject2.has("modified_mining")) {
            this.mining = rPObject2.getInt("modified_mining");
        }
        if (rPObject2.has("level")) {
            this.level = rPObject2.getInt("level");
        }
        if (rPObject2.has("modified_level")) {
            this.level = rPObject2.getInt("modified_level");
        }
        if (rPObject2.has("atk_xp")) {
            this.atkXP = rPObject2.getInt("atk_xp");
        }
        if (rPObject2.has("def_xp")) {
            this.defXP = rPObject2.getInt("def_xp");
        }
        if (rPObject2.has("ratk_xp")) {
            this.ratkXP = rPObject2.getInt("ratk_xp");
        }
        if (rPObject2.has("mining_xp")) {
            this.miningXP = rPObject2.getInt("mining_xp");
        }
        if (rPObject2.has("atk_item")) {
            this.atkItem = rPObject2.getInt("atk_item");
        }
        if (rPObject2.has("def_item")) {
            this.defItem = rPObject2.getInt("def_item");
        }
        if (rPObject2.has("ratk_item")) {
            this.ratkItem = rPObject2.getInt("ratk_item");
        }
        if (rPObject2.has("mana")) {
            this.mana = rPObject2.getInt("mana");
        }
        if (rPObject2.has("modified_mana")) {
            this.mana = rPObject2.getInt("modified_mana");
        }
        if (rPObject2.has("base_mana")) {
            this.baseMana = rPObject2.getInt("base_mana");
        }
        if (rPObject2.has("modified_base_mana")) {
            this.baseMana = rPObject2.getInt("modified_base_mana");
        }
        if (rPObject2.has("capacity")) {
            this.capacity = rPObject2.getDouble("capacity");
        }
        if (rPObject2.has("modified_capacity")) {
            this.capacity = rPObject2.getDouble("modified_capacity");
        }
        if (rPObject2.has("base_capacity")) {
            this.baseCapacity = rPObject2.getDouble("base_capacity");
        }
        if (rPObject2.has("modified_base_capacity")) {
            this.baseCapacity = rPObject2.getDouble("modified_base_capacity");
        }
        if (rPObject2.has("ghostmode")) {
            this.ghostmode = true;
            this.fireChange(PROP_GHOSTMODE);
        }
        if (rPObject2.has("xp")) {
            n = rPObject2.getInt("xp");
            if (rPObject.has("xp") && this.isInHearingRange()) {
                int n4 = n - this.xp;
                if (n4 > 0) {
                    if (n4 == 1 || n4 >= 2 && n4 <= 4 || n4 >= 22 && n4 <= 24 || n4 >= 102 && n4 <= 104 || n4 >= 122 && n4 <= 124 || n4 >= 132 && n4 <= 134 || n4 >= 32 && n4 <= 34 || n4 >= 202 && n4 <= 204 || n4 >= 222 && n4 <= 224 || n4 >= 232 && n4 <= 234 || n4 >= 42 && n4 <= 44 || n4 >= 302 && n4 <= 304 || n4 >= 322 && n4 <= 324 || n4 >= 332 && n4 <= 334 || n4 >= 52 && n4 <= 54 || n4 >= 402 && n4 <= 404 || n4 >= 422 && n4 <= 424 || n4 >= 432 && n4 <= 434 || n4 >= 62 && n4 <= 64 || n4 >= 502 && n4 <= 504 || n4 >= 522 && n4 <= 524 || n4 >= 532 && n4 <= 534 || n4 >= 72 && n4 <= 74 || n4 >= 602 && n4 <= 604 || n4 >= 622 && n4 <= 624 || n4 >= 632 && n4 <= 634 || n4 >= 82 && n4 <= 84 || n4 >= 702 && n4 <= 704 || n4 >= 722 && n4 <= 724 || n4 >= 732 && n4 <= 734 || n4 >= 92 && n4 <= 94 || n4 >= 802 && n4 <= 804 || n4 >= 822 && n4 <= 824 || n4 >= 832 && n4 <= 834 || n4 >= 902 && n4 <= 904 || n4 >= 922 && n4 <= 924 || n4 >= 932 && n4 <= 934 || n4 >= 142 && n4 <= 144 || n4 >= 242 && n4 <= 244 || n4 >= 342 && n4 <= 344 || n4 >= 442 && n4 <= 444 || n4 >= 152 && n4 <= 154 || n4 >= 252 && n4 <= 254 || n4 >= 352 && n4 <= 354 || n4 >= 452 && n4 <= 454 || n4 >= 162 && n4 <= 164 || n4 >= 262 && n4 <= 264 || n4 >= 362 && n4 <= 364 || n4 >= 462 && n4 <= 464 || n4 >= 172 && n4 <= 174 || n4 >= 272 && n4 <= 274 || n4 >= 372 && n4 <= 374 || n4 >= 472 && n4 <= 474 || n4 >= 182 && n4 <= 184 || n4 >= 282 && n4 <= 284 || n4 >= 382 && n4 <= 384 || n4 >= 482 && n4 <= 484 || n4 >= 192 && n4 <= 194 || n4 >= 292 && n4 <= 294 || n4 >= 392 && n4 <= 394 || n4 >= 492 && n4 <= 494 || n4 >= 542 && n4 <= 544 || n4 >= 642 && n4 <= 644 || n4 >= 742 && n4 <= 744 || n4 >= 842 && n4 <= 844 || n4 >= 552 && n4 <= 554 || n4 >= 652 && n4 <= 654 || n4 >= 752 && n4 <= 754 || n4 >= 852 && n4 <= 854 || n4 >= 562 && n4 <= 564 || n4 >= 662 && n4 <= 664 || n4 >= 762 && n4 <= 764 || n4 >= 862 && n4 <= 864 || n4 >= 572 && n4 <= 574 || n4 >= 672 && n4 <= 674 || n4 >= 772 && n4 <= 774 || n4 >= 872 && n4 <= 874 || n4 >= 582 && n4 <= 584 || n4 >= 682 && n4 <= 684 || n4 >= 782 && n4 <= 784 || n4 >= 882 && n4 <= 884 || n4 >= 592 && n4 <= 594 || n4 >= 692 && n4 <= 694 || n4 >= 792 && n4 <= 794 || n4 >= 892 && n4 <= 894 || n4 >= 942 && n4 <= 944 || n4 >= 952 && n4 <= 954 || n4 >= 962 && n4 <= 964 || n4 >= 972 && n4 <= 974 || n4 >= 982 && n4 <= 984 || n4 >= 992 && n4 <= 994) {
                        this.addTextIndicator("+" + n4, NotificationType.SIGNIFICANT_POSITIVE);
                        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(this.getTitle() + " " + Grammar.genderVerb(this.getGender(), "dosta\u0142") + " " + Grammar.quantityplnoun(n4, "punkt") + " do\u015bwiadczenia.", NotificationType.SIGNIFICANT_POSITIVE));
                    } else {
                        this.addTextIndicator("+" + n4, NotificationType.SIGNIFICANT_POSITIVE);
                        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(this.getTitle() + " " + Grammar.genderVerb(this.getGender(), "dosta\u0142") + " " + n4 + " punkt\u00f3w do\u015bwiadczenia.", NotificationType.SIGNIFICANT_POSITIVE));
                    }
                } else if (n4 < 0) {
                    this.addTextIndicator("" + n4, NotificationType.SIGNIFICANT_NEGATIVE);
                    ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(this.getTitle() + " traci " + Grammar.quantityplnoun(-n4, "punkt") + " do\u015bwiadczenia.", NotificationType.SIGNIFICANT_NEGATIVE));
                }
            }
            this.xp = n;
        }
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put("level", this.getLevel());
        linkedHashMap.put("def", this.getDef());
        linkedHashMap.put("atk", this.getAtk());
        linkedHashMap.put("ratk", this.getRatk());
        linkedHashMap.put("mining", this.getMining());
        for (String string : linkedHashMap.keySet()) {
            if (!rPObject2.has(string) || !rPObject.has(string)) continue;
            this.onLevelChanged(string, (Integer)linkedHashMap.get(string), rPObject.getInt(string));
        }
    }

    protected void onLevelChanged(String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        if (this.isInHearingRange()) {
            String string2 = this.getTitle();
            NotificationType notificationType = NotificationType.SIGNIFICANT_POSITIVE;
            if (n > n2) {
                string2 = string2 + " " + Grammar.genderVerb(this.getGender(), "osi\u0105gn\u0105\u0142") + " ";
            } else if (n < n2) {
                string2 = string2 + " " + Grammar.genderVerb(this.getGender(), "spad\u0142") + " do ";
                notificationType = NotificationType.SIGNIFICANT_NEGATIVE;
            }
            string = string.replace("def", "obrony");
            string = string.replace("ratk", "strzelnictwa");
            string = string.replace("atk", "ataku");
            string = string.replace("mining", "g\u00f3rnictwa");
            String string3 = " poziom";
            if (n < n2) {
                string3 = string3 + "u";
            }
            string2 = string.equals("level") ? string2 + n + string3 : string2 + n + string3 + " " + string;
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string2, notificationType));
            ClientSingletonRepository.getScreenController().addText(this.getX() + this.getWidth() / 2.0, this.getY(), string2, notificationType, false);
        }
    }

    private void onDeath() {
        if (!this.attackers.isEmpty()) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Entity object2 : this.attackers) {
                linkedList.add(object2.getTitle());
            }
            String string = Grammar.enumerateCollection(linkedList);
            String string2 = this.getTitle() + " " + Grammar.genderNouns(this.getTitle(), "zosta\u0142") + " " + Grammar.genderNouns(this.getTitle(), "zabity") + " przez " + (String)string;
            if (this.getGender() == null) {
                return;
            }
            ClientSingletonRepository.getUserInterface().addEventLine(new StandardEventLine(string2));
        }
        this.playSoundFromCategory(SoundLayer.FIGHTING_NOISE.groupName, "death");
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        super.onChangedRemoved(rPObject, rPObject2);
        if (rPObject2.has("outfit_ext") || rPObject2.has("outfit")) {
            if (rPObject2.has("outfit_ext")) {
                this.outfit_ext = null;
            }
            if (rPObject2.has("outfit")) {
                this.outfit_old = -1;
            }
            this.fireChange(PROP_OUTFIT);
        }
        for (StatusID statusID : this.statuses) {
            if (!rPObject2.has(statusID.getAttribute())) continue;
            this.setStatus(statusID, false);
        }
        this.setEatAndChoke(false, rPObject2.has("eating"), rPObject2.has("choking"));
        if (rPObject2.has("ghostmode")) {
            this.ghostmode = false;
            this.fireChange(PROP_GHOSTMODE);
        }
        if (rPObject2.has("target")) {
            this.onStopAttack();
            if (this.attackTarget != null) {
                this.attackTarget.onStopAttacked(this);
                this.attackTarget = null;
            }
        }
        if (rPObject2.has("unnamed")) {
            this.showTitle = true;
            this.fireChange(PROP_TITLE);
        }
        if (rPObject2.has("no_hpbar")) {
            this.showHP = true;
            this.fireChange(PROP_HP_DISPLAY);
        }
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public boolean showHPBar() {
        return this.showHP;
    }

    public boolean isImmortal() {
        return this.isImmortal;
    }

    public boolean castsShadow() {
        return this.castShadow;
    }

    public String getShadowStyle() {
        if (this.shadowStyle == null) {
            return null;
        }
        return "data/sprites/shadow/" + this.shadowStyle + ".png";
    }

    static {
        statusProp.put(StatusID.CONFUSE, PROP_CONFUSED);
        statusProp.put(StatusID.POISON, PROP_POISONED);
        statusProp.put(StatusID.BLEED, PROP_BLEEDING);
        statusProp.put(StatusID.SHOCK, PROP_SHOCK);
        statusProp.put(StatusID.ZOMBIE, PROP_ZOMBIE);
        statusProp.put(StatusID.HEAVY, PROP_HEAVY);
        PROP_ATTACK = new Property();
    }

    public static enum Resolution {
        HIT,
        BLOCKED,
        MISSED;

    }
}

