/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.SpeedPredictor;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.common.Direction;
import games.stendhal.common.NotificationType;
import games.stendhal.common.grammar.Grammar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

public class User
extends Player {
    private static final StaticUserProxy NO_USER = new NoUserProxy();
    private static final String IGNORE_SLOT = "!ignore";
    private static String groupLootmode;
    private static Set<String> groupMembers;
    private static StaticUserProxy userProxy;
    private final Set<String> ignore = new HashSet<String>();
    private final SpeedPredictor speedPredictor;

    public User() {
        this.speedPredictor = User.isNull() ? new SpeedPredictor() : new SpeedPredictor(User.userProxy.getUser().speedPredictor);
        userProxy = new NormalUserProxy(this);
    }

    public static User get() {
        return userProxy.getUser();
    }

    public static boolean isNull() {
        return userProxy == NO_USER;
    }

    static void setNull() {
        userProxy = NO_USER;
    }

    public static String getCharacterName() {
        return userProxy.getName();
    }

    public static int getPlayerLevel() {
        return userProxy.getPlayerLevel();
    }

    public static String getServerRelease() {
        return userProxy.getServerRelease();
    }

    public static boolean hasBuddy(String string) {
        return userProxy.hasBuddy(string);
    }

    public static boolean isAdmin() {
        return userProxy.isAdmin();
    }

    public static boolean isGroupSharingLoot() {
        return "shared".equals(groupLootmode);
    }

    public static boolean isIgnoring(String string) {
        return userProxy.isIgnoring(string);
    }

    public static boolean isPlayerInGroup(String string) {
        return groupMembers.contains(string);
    }

    public static void updateGroupStatus(Collection<String> collection, String string) {
        Set<String> set = groupMembers;
        groupMembers = collection == null ? Collections.emptySet() : new HashSet<String>(collection);
        groupLootmode = string;
        for (IEntity iEntity : GameObjects.getInstance()) {
            if (!(iEntity instanceof Player) || !set.contains(iEntity.getName()) && !groupMembers.contains(iEntity.getName())) continue;
            ((Player)iEntity).fireChange(RPEntity.PROP_GROUP_MEMBERSHIP);
        }
    }

    static double squaredDistanceTo(double d, double d2) {
        return userProxy.squareDistanceTo(d, d2);
    }

    private void addIgnore(RPObject rPObject) {
        for (String string : rPObject) {
            if (string.charAt(0) != '_') continue;
            this.ignore.add(string.substring(1));
        }
    }

    private void removeIgnore(RPObject rPObject) {
        for (String string : rPObject) {
            if (string.charAt(0) != '_') continue;
            this.ignore.remove(string.substring(1));
        }
    }

    public int findItem(String string, String string2) {
        RPSlot rPSlot = this.getSlot(string);
        if (rPSlot == null) {
            return -1;
        }
        for (RPObject rPObject : rPSlot) {
            if (!rPObject.get("name").equals(string2)) continue;
            return rPObject.getID().getObjectID();
        }
        return -1;
    }

    public boolean hasPet() {
        return this.rpObject.has("pet");
    }

    public int getPetID() {
        return this.rpObject.getInt("pet");
    }

    public boolean hasSheep() {
        return this.rpObject.has("sheep");
    }

    public int getSheepID() {
        return this.rpObject.getInt("sheep");
    }

    public boolean hasGoat() {
        return this.rpObject.has("goat");
    }

    public int getGoatID() {
        return this.rpObject.getInt("goat");
    }

    public String getZoneName() {
        return this.getID().getZoneID();
    }

    @Override
    public boolean isUser() {
        return true;
    }

    @Override
    protected void onAway(String string) {
        super.onAway(string);
        String string2 = string == null ? "Nie jeste\u015b ju\u017c " + Grammar.genderVerb(this.getGender(), "oznaczony") + " jako " + Grammar.genderVerb(this.getGender(), "oddalony") + "." : Grammar.genderVerb(this.getGender(), "Zosta\u0142e\u015b") + " " + Grammar.genderVerb(this.getGender(), "oznaczony") + " jako " + Grammar.genderVerb(this.getGender(), "oddalony") + ".";
        this.notifyUser(string2, NotificationType.INFORMATION);
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject != null) {
            RPObject rPObject3;
            this.notifyUserAboutPlayerOnlineChanges(rPObject2);
            if (rPObject2.hasSlot(IGNORE_SLOT) && (rPObject3 = rPObject2.getSlot(IGNORE_SLOT).getFirst()) != null) {
                this.addIgnore(rPObject3);
            }
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        RPObject rPObject3;
        super.onChangedRemoved(rPObject, rPObject2);
        if (rPObject2.hasSlot(IGNORE_SLOT) && (rPObject3 = rPObject2.getSlot(IGNORE_SLOT).getFirst()) != null) {
            this.removeIgnore(rPObject3);
        }
    }

    @Override
    public void onHealed(int n) {
        super.onHealed(n);
        String string = Grammar.quantityplnoun(n, "punkt") + " \u017cycia";
        this.notifyUser(this.getTitle() + " odzyska\u0142 " + string + ".", NotificationType.HEAL);
    }

    private void notifyUser(String string, NotificationType notificationType) {
        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string, notificationType));
    }

    private void notifyUserAboutPlayerOnlineChanges(RPObject rPObject) {
        this.notifyUserAboutPlayerStatus(rPObject, "offline", " opu\u015bci\u0142 PolanieOnLine.");
        this.notifyUserAboutPlayerStatus(rPObject, "online", " zawita\u0142 do PolanieOnLine.");
    }

    private void notifyUserAboutPlayerStatus(RPObject rPObject, String string, String string2) {
        if (rPObject.has(string)) {
            String[] stringArray;
            for (String string3 : stringArray = rPObject.get(string).split(",")) {
                this.notifyUser(string3 + string2, NotificationType.INFORMATION);
            }
        }
    }

    public void predictMovement(Direction direction, boolean bl) {
        if (this.stopped()) {
            if (this.isConfused()) {
                direction = direction.oppositeDirection();
            }
            if (!bl) {
                double d = this.speedPredictor.getSpeed();
                this.setSpeed((double)direction.getdx() * d, (double)direction.getdy() * d);
                this.fireChange(PROP_SPEED);
                this.speedPredictor.startPrediction();
            }
            this.setDirection(direction);
        }
    }

    @Override
    protected void processPositioning(RPObject rPObject, RPObject rPObject2) {
        if (this.speedPredictor.isActive() && (rPObject2.has("direction") || rPObject2.has("x") || rPObject2.has("y"))) {
            this.speedPredictor.onMoved();
        }
        super.processPositioning(rPObject, rPObject2);
    }

    public void stopMovement() {
        RPAction rPAction = new RPAction();
        rPAction.put("type", "walk");
        rPAction.put("mode", "stop");
        ClientSingletonRepository.getClientFramework().send(rPAction);
    }

    static {
        groupMembers = Collections.emptySet();
        userProxy = NO_USER;
    }

    private static class NoUserProxy
    implements StaticUserProxy {
        private NoUserProxy() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public int getPlayerLevel() {
            return 0;
        }

        @Override
        public String getServerRelease() {
            return null;
        }

        @Override
        public User getUser() {
            return null;
        }

        @Override
        public boolean hasBuddy(String string) {
            return false;
        }

        @Override
        public boolean isAdmin() {
            return false;
        }

        @Override
        public boolean isIgnoring(String string) {
            return false;
        }

        @Override
        public double squareDistanceTo(double d, double d2) {
            return Double.POSITIVE_INFINITY;
        }
    }

    private static class NormalUserProxy
    implements StaticUserProxy {
        private final User user;

        NormalUserProxy(User user) {
            this.user = user;
        }

        @Override
        public String getName() {
            return this.user.getName();
        }

        @Override
        public int getPlayerLevel() {
            return this.user.getLevel();
        }

        @Override
        public String getServerRelease() {
            return this.user.rpObject.get("release");
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public boolean hasBuddy(String string) {
            return this.user.rpObject.has("buddies", string);
        }

        @Override
        public boolean isAdmin() {
            return this.user.rpObject != null && this.user.rpObject.has("adminlevel") && this.user.rpObject.getInt("adminlevel") >= 6;
        }

        @Override
        public double squareDistanceTo(double d, double d2) {
            double d3 = this.user.getX() - d;
            double d4 = this.user.getY() - d2;
            return d3 * d3 + d4 * d4;
        }

        @Override
        public boolean isIgnoring(String string) {
            return this.user.ignore.contains(string);
        }
    }

    private static interface StaticUserProxy {
        public String getName();

        public int getPlayerLevel();

        public String getServerRelease();

        public User getUser();

        public boolean hasBuddy(String var1);

        public boolean isAdmin();

        public boolean isIgnoring(String var1);

        public double squareDistanceTo(double var1, double var3);
    }
}

