/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity.factory;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.events.EventDispatcher;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public class EntityFactory {
    private static final Logger logger = Logger.getLogger(EntityFactory.class);

    protected EntityFactory() {
    }

    public static IEntity createEntity(RPObject rPObject) {
        try {
            Class<? extends IEntity> clazz;
            String string = rPObject.getRPClass().getName();
            if (string.equals("player") && rPObject.has("name") && StendhalClient.get().getCharacter().equalsIgnoreCase(rPObject.get("name"))) {
                User user = new User();
                user.initialize(rPObject);
                EventDispatcher.dispatchEvents(rPObject, user);
                return user;
            }
            String string2 = null;
            if (rPObject.has("class")) {
                string2 = rPObject.get("class");
            }
            String string3 = null;
            if (rPObject.has("subclass")) {
                string3 = rPObject.get("subclass");
            }
            if ((clazz = EntityMap.getClass(string, string2, string3)) == null) {
                return null;
            }
            IEntity iEntity = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            iEntity.initialize(rPObject);
            if (iEntity instanceof Entity) {
                EventDispatcher.dispatchEvents(rPObject, (Entity)iEntity);
            }
            return iEntity;
        }
        catch (Exception exception) {
            logger.error((Object)("Error creating entity for object: " + rPObject), (Throwable)exception);
            return null;
        }
    }
}

