/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.ScalingModel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractScalingModel
implements ScalingModel {
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private int representation;

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    protected boolean setRepresentation(int n) {
        int n2 = this.representation;
        this.representation = n;
        if (n2 != n) {
            this.fireChanged();
            return true;
        }
        return false;
    }

    @Override
    public int getRepresentation() {
        return this.representation;
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

