/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;

public class ComponentPaintCache {
    private Cacheable component;
    private int oldWidth;
    private int oldHeight;
    private Image cachedImage;
    private boolean paintChildren;

    public ComponentPaintCache(Cacheable cacheable) {
        this.component = cacheable;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.component.getWidth();
        int n2 = this.component.getHeight();
        if (this.cachedImage == null || this.oldWidth != n || this.oldHeight != n2) {
            this.oldWidth = n;
            this.oldHeight = n2;
            this.cachedImage = this.component.getGraphicsConfiguration().createCompatibleImage(n, n2, 1);
            Graphics graphics2 = this.cachedImage.getGraphics();
            graphics2.setClip(0, 0, n, n2);
            this.component.paintComponent(graphics2);
            this.component.paintBorder(graphics2);
            if (this.paintChildren) {
                this.component.paintChildren(graphics2);
            }
            graphics2.dispose();
        }
        graphics.drawImage(this.cachedImage, 0, 0, null);
    }

    public void setPaintChildren(boolean bl) {
        this.paintChildren = bl;
    }

    public static interface Cacheable {
        public int getWidth();

        public int getHeight();

        public void paintComponent(Graphics var1);

        public void paintBorder(Graphics var1);

        public void paintChildren(Graphics var1);

        public GraphicsConfiguration getGraphicsConfiguration();
    }
}

