/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.entity.Item;
import games.stendhal.client.gui.DropTarget;
import games.stendhal.client.gui.NumberDocumentFilter;
import games.stendhal.client.gui.layout.SBoxLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

class DropAmountChooser {
    private static final int BORDER = 2;
    private final Item item;
    private final DropTarget target;
    private final Point location;
    private final JPopupMenu popup;
    private JSpinner spinner;

    DropAmountChooser(Item item, DropTarget dropTarget, Point point) {
        this.item = item;
        this.target = dropTarget;
        this.location = point;
        this.popup = this.createPopup();
        final JTextField jTextField = this.getTextField();
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JTextComponent)jTextField).selectAll();
                    }
                });
            }
        });
    }

    protected void show(Component component, Point point) {
        this.popup.show(component, point.x, point.y);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DropAmountChooser.this.getTextField().requestFocus();
            }
        });
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 0, this.item.getQuantity(), 1);
        this.spinner = new JSpinner(spinnerNumberModel);
        PlainDocument plainDocument = new PlainDocument(){
            private DocumentFilter filter;

            @Override
            public DocumentFilter getDocumentFilter() {
                if (this.filter == null) {
                    this.filter = new NumberDocumentFilter(DropAmountChooser.this.getTextField(), true);
                }
                return this.filter;
            }
        };
        this.getTextField().setDocument(plainDocument);
        JButton jButton = new JButton("Po\u0142\u00f3\u017c");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropAmountChooser.this.doDrop();
            }
        };
        this.getTextField().addActionListener(actionListener);
        jButton.addActionListener(actionListener);
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jComponent.add(this.spinner);
        jComponent.add(jButton);
        jPopupMenu.add(jComponent);
        return jPopupMenu;
    }

    private void doDrop() {
        Object object = this.spinner.getValue();
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n > 0) {
                this.target.dropEntity(this.item, n, this.location);
            }
            this.popup.setVisible(false);
        }
    }

    private JTextField getTextField() {
        JComponent jComponent = this.spinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        Logger.getLogger(DropAmountChooser.class).error((Object)"Unknown editor type", new Throwable());
        return new JTextField();
    }
}

