/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

class Initializer {
    private static final String DECORATIVE_FONT_NAME = "BlackChancery";
    private static final String TALLY_FONT_NAME = "Tally";
    private static final Logger logger = Logger.getLogger(Initializer.class);

    Initializer() {
    }

    static void init() {
    }

    private static void initFont(String string) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean bl = true;
        for (String string2 : graphicsEnvironment.getAvailableFontFamilyNames()) {
            if (!string.equals(string2)) continue;
            bl = false;
            break;
        }
        if (bl) {
            String string3 = "data/font/" + string + ".ttf";
            try {
                graphicsEnvironment.registerFont(Font.createFont(0, DataLoader.getResourceAsStream(string3)));
            }
            catch (FontFormatException | IOException exception) {
                logger.error((Object)("Error loading custom font '" + string3 + '\"'), (Throwable)exception);
            }
        }
    }

    private static void initApplicationName() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Field field = toolkit.getClass().getDeclaredField("awtAppClassName");
            field.setAccessible(true);
            field.set(toolkit, stendhal.GAME_NAME);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.debug((Object)("Not setting X application name " + noSuchFieldException.getMessage()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug((Object)("Not setting X application name " + illegalArgumentException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.debug((Object)("Not setting X application name: " + illegalAccessException.getMessage()));
        }
        catch (RuntimeException runtimeException) {
            logger.debug((Object)("Not setting X application name: " + runtimeException.getMessage()));
        }
    }

    static {
        Initializer.initFont(DECORATIVE_FONT_NAME);
        Initializer.initFont(TALLY_FONT_NAME);
        for (String string : new String[]{"Bold", "BoldItalic", "Italic", "Regular"}) {
            Initializer.initFont("Amaranth-" + string);
            Initializer.initFont("Carlito-" + string);
        }
        Initializer.initFont("NotoEmoji-Regular");
        Initializer.initApplicationName();
    }
}

