/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressBar
extends JDialog {
    private static final long serialVersionUID = 6241161656154797719L;
    private static final int SLEEP_TIME = 200;
    private static final int MAX_VALUE = 100;
    private static final int STEP_SIZE = 2;
    private JProgressBar progressBar;
    private int stepSizeMultiplier = 1;
    private int stepCounter;
    private final Timer timer = new Timer(200, new Updater());

    public ProgressBar(JDialog jDialog) {
        super(jDialog, "\u0141\u0105czenie...", true);
        this.initializeComponents();
        this.pack();
        this.setLocationRelativeTo(jDialog);
    }

    private void initializeComponents() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(new JLabel("\u0141\u0105czenie..."));
        jPanel.add(Box.createVerticalStrut(5));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(false);
        jPanel.add(this.progressBar);
    }

    public void start() {
        this.timer.start();
        this.setVisible(true);
    }

    public void step() {
        this.stepCounter = 3;
        this.stepSizeMultiplier = 3;
    }

    public void finish() {
        this.stepCounter = 20;
        this.stepSizeMultiplier = 3;
        this.timer.setDelay(15);
    }

    public void cancel() {
        this.timer.stop();
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    private class Updater
    implements ActionListener {
        private int counter = 0;

        private Updater() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.counter += 2 * ProgressBar.this.stepSizeMultiplier;
            ProgressBar.this.progressBar.setValue(this.counter);
            if (ProgressBar.this.stepCounter >= 0) {
                if (ProgressBar.this.stepCounter == 0) {
                    ProgressBar.this.stepSizeMultiplier = 1;
                }
                ProgressBar.this.stepCounter--;
            }
            if (this.counter > 100) {
                ProgressBar.this.cancel();
            }
        }
    }
}

