/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameScreen;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.gui.j2d.BackgroundPainter;
import games.stendhal.client.gui.j2d.TextBoxFactory;
import games.stendhal.client.listener.PositionChangeListener;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.common.NotificationType;
import java.awt.Color;
import javax.swing.SwingUtilities;

public class ScreenController
implements PositionChangeListener {
    private static ScreenController instance;
    private static final int BUBBLE_TEXT_WIDTH = 340;
    private static final String TUTORIAL_BACKGROUND = "data/gui/tutorial_background.png";
    private static final int TUTORIAL_LEFT_TILE_WIDTH = 48;
    private static final int TUTORIAL_CENTER_TILE_WIDTH = 8;
    private static final int TUTORIAL_TOP_TILE_HEIGHT = 32;
    private static final int TUTORIAL_CENTER_TILE_HEIGHT = 8;
    private final GameScreen screen;
    private TextBoxFactory textBoxFactory;

    public static ScreenController get(GameScreen gameScreen) {
        if (instance == null) {
            instance = new ScreenController(gameScreen);
        }
        return instance;
    }

    public static ScreenController get() {
        return instance;
    }

    private ScreenController(GameScreen gameScreen) {
        this.screen = gameScreen;
    }

    private void addStaticText(final Sprite sprite, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenController.this.screen.addStaticText(sprite, n, n2);
            }
        });
    }

    public void addText(final double d, final double d2, String string, NotificationType notificationType, boolean bl) {
        final Sprite sprite = this.createTextBox(string, notificationType, bl);
        final int n = string.length();
        if (!bl) {
            this.addStaticText(sprite, n, this.getPriority(notificationType));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenController.this.screen.addTextBox(sprite, d, d2, n);
                }
            });
        }
    }

    public void addText(final Entity entity, String string, NotificationType notificationType, boolean bl) {
        final Sprite sprite = this.createTextBox(string, notificationType, bl);
        final int n = string.length();
        if (!bl) {
            this.addStaticText(sprite, n, this.getPriority(notificationType));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenController.this.screen.addTextBox(sprite, entity, n);
                }
            });
        }
    }

    public void addEmoji(final Entity entity, final Sprite sprite) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenController.this.screen.addEmoji(sprite, entity);
            }
        });
    }

    private int getPriority(NotificationType notificationType) {
        switch (notificationType) {
            case TUTORIAL: {
                return 1;
            }
            case SUPPORT: {
                return 2;
            }
        }
        return 0;
    }

    void setOffline(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenController.this.screen.setOffline(bl);
            }
        });
    }

    @Override
    public void positionChanged(final double d, final double d2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenController.this.screen.positionChanged(d, d2);
            }
        });
    }

    private Sprite createTextBox(String string, NotificationType notificationType, boolean bl) {
        if (notificationType == NotificationType.TUTORIAL) {
            BackgroundPainter backgroundPainter = new BackgroundPainter(TUTORIAL_BACKGROUND, 48, 8, 32, 8);
            return this.getTextFactory().createFancyTextBox(string, notificationType.getColor(), 340, 45, 6, 6, 6, backgroundPainter);
        }
        Color color = Color.white;
        if (!bl) {
            color = new Color(60, 30, 0);
        }
        return this.getTextFactory().createTextBox(string, 340, notificationType.getColor(), color, bl);
    }

    private TextBoxFactory getTextFactory() {
        if (this.textBoxFactory == null) {
            this.textBoxFactory = new TextBoxFactory();
        }
        return this.textBoxFactory;
    }
}

