/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameLoop;
import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.ItemPanel;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public class SlotGrid
extends JComponent
implements ContentChangeListener,
Inspectable {
    private static final int PADDING = 1;
    private static final Logger logger = Logger.getLogger(SlotGrid.class);
    private final List<ItemPanel> panels = new ArrayList<ItemPanel>();
    private IEntity parent;
    private String slotName;

    public SlotGrid(int n, int n2) {
        this.setSlotsLayout(n, n2);
    }

    public void setSlotsLayout(int n, int n2) {
        this.setLayout(new GridLayout(n2, n, 1, 1));
        for (ItemPanel itemPanel : this.panels) {
            this.remove(itemPanel);
        }
        this.panels.clear();
        for (int i = 0; i < n * n2; ++i) {
            ItemPanel itemPanel;
            itemPanel = new ItemPanel(null, null);
            itemPanel.setItemNumber(i);
            this.panels.add(itemPanel);
            this.add(itemPanel);
        }
    }

    @SafeVarargs
    public final void setAcceptedTypes(Class<? extends IEntity> ... classArray) {
        List<Class<? extends IEntity>> list = Arrays.asList(classArray);
        for (ItemPanel itemPanel : this.panels) {
            itemPanel.setAcceptedTypes(list);
        }
    }

    public void setSlot(final IEntity iEntity, final String string) {
        if (!GameLoop.isGameLoop()) {
            GameLoop.get().runOnce(new Runnable(){

                @Override
                public void run() {
                    SlotGrid.this.setSlot(iEntity, string);
                }
            });
            return;
        }
        if (this.parent != null) {
            this.parent.removeContentChangeListener(this);
        }
        this.parent = iEntity;
        this.slotName = string;
        for (ItemPanel itemPanel : this.panels) {
            itemPanel.setParent(iEntity);
            itemPanel.setName(string);
        }
        iEntity.addContentChangeListener(this);
        this.scanSlotContent();
    }

    public String getSlotName() {
        return this.slotName;
    }

    @Override
    public void setInspector(Inspector inspector) {
        for (ItemPanel itemPanel : this.panels) {
            itemPanel.setInspector(inspector);
        }
    }

    void release() {
        if (this.parent != null) {
            this.parent.removeContentChangeListener(this);
        }
        GameLoop.get().runOnce(new Runnable(){

            @Override
            public void run() {
                for (ItemPanel itemPanel : SlotGrid.this.panels) {
                    itemPanel.setEntity(null);
                }
                SlotGrid.this.parent = null;
                SlotGrid.this.slotName = null;
            }
        });
    }

    private void scanSlotContent() {
        if (this.parent == null || this.slotName == null) {
            return;
        }
        for (ItemPanel itemPanel : this.panels) {
            itemPanel.setEntity(null);
        }
        RPSlot rPSlot = this.parent.getSlot(this.slotName);
        this.contentAdded(rPSlot);
    }

    @Override
    public void contentAdded(RPSlot rPSlot) {
        if (rPSlot == null) {
            logger.debug((Object)("RPSlot for " + this.slotName + " is null"), new Throwable());
            return;
        }
        if (this.slotName.equals(rPSlot.getName())) {
            for (RPObject rPObject : rPSlot) {
                this.handleAdded(rPObject);
            }
        }
    }

    private void handleAdded(RPObject rPObject) {
        RPObject.ID iD = rPObject.getID();
        for (ItemPanel object : this.panels) {
            IEntity iEntity = object.getEntity();
            if (iEntity == null || !iD.equals((Object)iEntity.getRPObject().getID())) continue;
            return;
        }
        IEntity iEntity = GameObjects.getInstance().get(rPObject);
        for (ItemPanel itemPanel : this.panels) {
            if (itemPanel.getEntity() != null) continue;
            itemPanel.setEntity(iEntity);
            return;
        }
        logger.error((Object)("More objects than slots: " + this.slotName));
    }

    @Override
    public void contentRemoved(RPSlot rPSlot) {
        if (this.slotName.equals(rPSlot.getName())) {
            for (RPObject rPObject : rPSlot) {
                RPObject.ID iD = rPObject.getID();
                for (ItemPanel itemPanel : this.panels) {
                    IEntity iEntity = itemPanel.getEntity();
                    if (iEntity == null || !iD.equals((Object)iEntity.getRPObject().getID()) || rPObject.size() != 1) continue;
                    itemPanel.setEntity(null);
                }
            }
            this.compressSlots();
        }
    }

    private void compressSlots() {
        Iterator<ItemPanel> iterator = this.panels.iterator();
        Iterator<ItemPanel> iterator2 = this.panels.iterator();
        while (iterator2.hasNext()) {
            ItemPanel itemPanel = iterator2.next();
            ItemPanel itemPanel2 = iterator.next();
            if (itemPanel2.getEntity() != null) continue;
            while (itemPanel.getEntity() == null) {
                if (iterator2.hasNext()) {
                    itemPanel = iterator2.next();
                    continue;
                }
                return;
            }
            itemPanel.moveViewTo(itemPanel2);
        }
    }
}

