/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class TransparencyGraphicsWrapper
extends Graphics2D {
    private final Graphics2D g;
    private Color origColor;
    private final int transparencyRatio;
    private AlphaComposite alcom;

    public TransparencyGraphicsWrapper(Graphics2D graphics2D, int n) {
        this.g = graphics2D;
        this.origColor = graphics2D.getColor();
        this.setModColor(this.origColor);
        this.transparencyRatio = n;
        this.alcom = AlphaComposite.getInstance(3, (float)n / 256.0f);
    }

    @Override
    public void draw(Shape shape) {
        this.g.draw(shape);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, affineTransform, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        graphics2D.drawImage(bufferedImage, bufferedImageOp, n, n2);
        graphics2D.dispose();
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        graphics2D.drawRenderedImage(renderedImage, affineTransform);
        graphics2D.dispose();
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        graphics2D.drawRenderableImage(renderableImage, affineTransform);
        graphics2D.dispose();
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.g.setColor(this.origColor);
        this.g.drawString(string, n, n2);
        this.setModColor(this.origColor);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.g.setColor(this.origColor);
        this.g.drawString(string, f, f2);
        this.setModColor(this.origColor);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.g.setColor(this.origColor);
        this.g.drawString(attributedCharacterIterator, n, n2);
        this.setModColor(this.origColor);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.g.setColor(this.origColor);
        this.g.drawString(attributedCharacterIterator, f, f2);
        this.setModColor(this.origColor);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.g.drawGlyphVector(glyphVector, f, f2);
    }

    @Override
    public void fill(Shape shape) {
        this.g.fill(shape);
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.g.hit(rectangle, shape, bl);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite composite) {
        this.g.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        this.g.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.g.setStroke(stroke);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g.setRenderingHint(key, object);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g.getRenderingHint(key);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.g.setRenderingHints(map);
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.g.addRenderingHints(map);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g.getRenderingHints();
    }

    @Override
    public void translate(int n, int n2) {
        this.g.translate(n, n2);
    }

    @Override
    public void translate(double d, double d2) {
        this.g.translate(d, d2);
    }

    @Override
    public void rotate(double d) {
        this.g.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.g.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.g.scale(d, d2);
    }

    @Override
    public void shear(double d, double d2) {
        this.g.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.g.transform(affineTransform);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.g.setTransform(affineTransform);
    }

    @Override
    public AffineTransform getTransform() {
        return this.g.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.g.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.g.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * this.transparencyRatio / 255);
        this.g.setBackground(color2);
    }

    @Override
    public Color getBackground() {
        return this.g.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.g.getStroke();
    }

    @Override
    public void clip(Shape shape) {
        this.g.clip(shape);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return new TransparencyGraphicsWrapper((Graphics2D)this.g.create(), this.transparencyRatio);
    }

    @Override
    public Color getColor() {
        return this.g.getColor();
    }

    @Override
    public void setColor(Color color) {
        this.origColor = color;
        this.setModColor(color);
    }

    @Override
    public void setPaintMode() {
        this.g.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.g.setXORMode(color);
    }

    @Override
    public Font getFont() {
        return this.g.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.g.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    @Override
    public Shape getClip() {
        return this.g.getClip();
    }

    @Override
    public void setClip(Shape shape) {
        this.g.setClip(shape);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.copyArea(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.g.clearRect(n, n2, n3, n4);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.g.drawOval(n, n2, n3, n4);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.g.fillOval(n, n2, n3, n4);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolyline(nArray, nArray2, n);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolygon(nArray, nArray2, n);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.fillPolygon(nArray, nArray2, n);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, n, n2, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, n, n2, n3, n4, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, n, n2, color, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, n, n2, n3, n4, color, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.setComposite(this.alcom);
        boolean bl = graphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    private void setModColor(Color color) {
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * this.transparencyRatio / 255);
        this.g.setColor(color2);
    }
}

