/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.achievementlog;

import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.achievementlog.AchievementLogAdjusts;
import games.stendhal.client.gui.achievementlog.AchievementLogComponents;
import games.stendhal.client.gui.achievementlog.AchievementLogController;
import games.stendhal.client.gui.achievementlog.AchievementLogRenderers;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Color;
import java.awt.Window;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

class AchievementLog {
    private static final int TABLE_WIDTH = 720;
    private static final int TABLE_HEIGHT = 500;
    private JDialog window;
    private JComponent page;
    private AchievementLogRenderers renderer = AchievementLogRenderers.get();
    public static final int PAD = 5;

    AchievementLog(String string) {
        this.window = new JDialog(j2DClient.get().getMainFrame(), string);
        this.window.setDefaultCloseOperation(2);
        this.window.setLayout(new SBoxLayout(false, 5));
        this.window.setResizable(false);
        this.page = SBoxLayout.createContainer(false, 5);
        this.window.add(this.page);
        AchievementLogComponents achievementLogComponents = new AchievementLogComponents();
        this.page.add(achievementLogComponents.getHeaderText(720, 5));
        this.page.add(achievementLogComponents.getViewTable(this.getTable(), 720, 500, 5));
        this.page.add(achievementLogComponents.getButtons(this.window));
        WindowUtils.closeOnEscape(this.window);
        WindowUtils.watchFontSize(this.window);
        WindowUtils.trackLocation(this.window, "achievement_log", false);
        this.window.pack();
    }

    private JComponent getTable() {
        Object object;
        JTable jTable = this.createTable();
        jTable.setEnabled(false);
        jTable.setFillsViewportHeight(true);
        jTable.setAutoResizeMode(3);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new AchievementLogRenderers.SpriteCellRenderer(this.renderer));
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new AchievementLogRenderers.DescriptionCellRenderer(this.renderer));
        AchievementLogRenderers.HeaderRenderer headerRenderer = new AchievementLogRenderers.HeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((TableColumn)object).setHeaderRenderer(headerRenderer);
        }
        object = new AchievementLogAdjusts();
        ((AchievementLogAdjusts)object).columnWidths(jTable);
        ((AchievementLogAdjusts)object).rowHeights(jTable);
        return jTable;
    }

    private JTable createTable() {
        Object[] objectArray = new String[]{"#", "Ikona", "Opis"};
        List<String> list = AchievementLogController.get().getList();
        Object[][] objectArray2 = new Object[list.size()][];
        int n = 0;
        for (String string : list) {
            objectArray2[n] = this.createDataRow(string.split(":"));
            ++n;
        }
        return new JTable(objectArray2, objectArray);
    }

    private Object[] createDataRow(String[] stringArray) {
        Object[] objectArray = new Object[3];
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        boolean bl = stringArray[3].equals("true");
        objectArray[0] = "";
        objectArray[1] = this.getAchievementImage(string, bl);
        objectArray[2] = this.getAchievementDesc(string2, string3);
        if (bl) {
            objectArray[0] = "\u2714";
        }
        return objectArray;
    }

    private String getAchievementDesc(String string, String string2) {
        String string3 = "<html><span style=\"font-weight: bold;\">" + string + "</span><br/><span style=\"font-weight: normal; font-style: italic;\">" + string2 + ".</span></html>";
        return string3;
    }

    private Sprite getAchievementImage(String string, boolean bl) {
        String string2 = "/data/sprites/achievements/" + string.toLowerCase() + ".png";
        Sprite sprite = bl ? SpriteStore.get().getSprite(string2) : SpriteStore.get().getColoredSprite(string2, Color.LIGHT_GRAY);
        if (sprite.getWidth() > sprite.getHeight()) {
            sprite = SpriteStore.get().getAnimatedSprite(sprite, 100);
        }
        return sprite;
    }

    Window getWindow() {
        return this.window;
    }
}

