/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.chattext;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.gui.chattext.ChatCache;
import games.stendhal.client.scripting.ChatLineParser;
import games.stendhal.client.stendhal;
import games.stendhal.common.constants.SoundLayer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class ChatTextController {
    private static final int MAX_TEXT_LENGTH = 1000;
    private final JTextField playerChatText = new JTextField("");
    private ChatCache cache;
    private static ChatTextController instance;

    public static ChatTextController get() {
        if (instance == null) {
            instance = new ChatTextController();
        }
        return instance;
    }

    private ChatTextController() {
        this.playerChatText.setFocusTraversalKeysEnabled(false);
        Document document = this.playerChatText.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new SizeFilter(1000));
        }
        this.setupKeys();
        this.playerChatText.addActionListener(new ParserHandler());
        StendhalClient stendhalClient = StendhalClient.get();
        String string = null;
        if (stendhalClient != null) {
            string = stendhal.getGameFolder() + "chat/out-" + stendhalClient.getCharacter() + ".log";
        }
        this.cache = new ChatCache(string);
        this.cache.loadChatCache();
        this.setCache(this.cache);
    }

    public boolean setFocus() {
        return this.playerChatText.requestFocusInWindow();
    }

    public JTextComponent getPlayerChatText() {
        return this.playerChatText;
    }

    public void setChatLine(String string) {
        this.playerChatText.setText(string);
    }

    private void setupKeys() {
        InputMap inputMap = this.playerChatText.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), "history_previous");
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), "history_next");
        inputMap.put(KeyStroke.getKeyStroke("F1"), "manual");
        ActionMap actionMap = this.playerChatText.getActionMap();
        actionMap.put("history_previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChatTextController.this.cache.hasPrevious()) {
                    ChatTextController.this.setChatLine(ChatTextController.this.cache.previous());
                }
            }
        });
        actionMap.put("history_next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChatTextController.this.cache.hasNext()) {
                    ChatTextController.this.setChatLine(ChatTextController.this.cache.next());
                }
            }
        });
        actionMap.put("manual", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SlashActionRepository.get("manual").execute(null, null);
            }
        });
    }

    public void addKeyListener(KeyListener keyListener) {
        this.playerChatText.addKeyListener(keyListener);
    }

    public String getText() {
        return this.playerChatText.getText();
    }

    private void setCache(ChatCache chatCache) {
        this.cache = chatCache;
    }

    private void clearLine() {
        this.cache.addlinetoCache(this.getText());
        this.setChatLine("");
    }

    public void saveCache() {
        this.cache.save();
    }

    private static class SizeFilter
    extends DocumentFilter {
        private static final String sound = "click-1";
        final int maxSize;

        SizeFilter(int n) {
            this.maxSize = n;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (filterBypass.getDocument().getLength() + string.length() <= this.maxSize) {
                super.insertString(filterBypass, n, string, attributeSet);
            } else {
                this.fail();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (filterBypass.getDocument().getLength() + string.length() - n2 <= this.maxSize) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            } else {
                this.fail();
            }
        }

        private void fail() {
            ClientSingletonRepository.getSound().getGroup(SoundLayer.USER_INTERFACE.groupName).play(sound, 0, null, null, false, true);
        }
    }

    private class ParserHandler
    implements ActionListener {
        private ParserHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ChatLineParser.parseAndHandle(string)) {
                ChatTextController.this.clearLine();
            }
        }
    }
}

