/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.group;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.group.GroupPanel;
import games.stendhal.common.NotificationType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GroupPanelController
implements GameObjects.GameObjectListener {
    private final GroupPanel panel;
    private final Set<String> members = new HashSet<String>();
    private boolean grouped = false;

    private GroupPanelController() {
        this.panel = new GroupPanel();
    }

    public JComponent getComponent() {
        return this.panel.getComponent();
    }

    public void update(final List<String> list, final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (list == null) {
                    GroupPanelController.this.panel.showHeader("<html>Nie jeste\u015b cz\u0142onkiem grupy.</html>");
                    if (GroupPanelController.this.grouped) {
                        String string3 = "Ju\u017c nie jeste\u015b cz\u0142onkiem grupy.";
                        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string3, NotificationType.CLIENT));
                        GroupPanelController.this.grouped = false;
                        GameObjects.getInstance().removeGameObjectListener(GroupPanelController.this);
                    }
                    GroupPanelController.this.panel.setMembers(null);
                } else {
                    String string4 = string2;
                    if (string2.equals("single")) {
                        string4 = "samodzielne";
                    }
                    if (string2.equals("shared")) {
                        string4 = "wsp\u00f3lne";
                    }
                    GroupPanelController.this.panel.showHeader("<html>Zbieranie: " + string4 + "</html>");
                    GroupPanelController.this.panel.setMembers(list);
                    GroupPanelController.this.panel.setLeader(string);
                    if (!GroupPanelController.this.grouped) {
                        GameObjects.getInstance().addGameObjectListener(GroupPanelController.this);
                    }
                    GroupPanelController.this.grouped = true;
                }
            }
        });
        if (list != null) {
            this.members.retainAll(list);
            LinkedList<String> linkedList = new LinkedList<String>(list);
            linkedList.removeAll(this.members);
            this.syncPlayerStatus(linkedList);
            this.members.addAll(linkedList);
        } else {
            this.members.clear();
        }
    }

    private void syncPlayerStatus(List<String> list) {
        final ArrayList<Player> arrayList = new ArrayList<Player>();
        for (IEntity iEntity : GameObjects.getInstance()) {
            if (!(iEntity instanceof Player) || !list.contains(iEntity.getName())) continue;
            arrayList.add((Player)iEntity);
        }
        if (!arrayList.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GroupPanelController.this.panel.addPlayers(arrayList);
                }
            });
        }
    }

    public void receiveInvite(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupPanelController.this.panel.receiveInvite(string);
            }
        });
    }

    public void expireInvite(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupPanelController.this.panel.expireInvite(string);
            }
        });
    }

    @Override
    public void addEntity(final IEntity iEntity) {
        if (iEntity instanceof Player) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GroupPanelController.this.panel.addPlayer((Player)iEntity);
                }
            });
        }
    }

    @Override
    public void removeEntity(final IEntity iEntity) {
        if (iEntity instanceof Player) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GroupPanelController.this.panel.removePlayer(iEntity);
                }
            });
        }
    }

    public static GroupPanelController get() {
        return Holder.instance;
    }

    private static class Holder {
        static GroupPanelController instance = new GroupPanelController();

        private Holder() {
        }
    }
}

