/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.group;

import games.stendhal.client.gui.LinearScalingModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Member
implements Comparable<Member> {
    private final String name;
    private boolean leader;
    private boolean present;
    private final LinearScalingModel hpModel = new LinearScalingModel();
    private ChangeListener listener;

    Member(String string) {
        this.name = string;
        this.hpModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Member.this.listener != null) {
                    Member.this.listener.stateChanged(new ChangeEvent(Member.this));
                }
            }
        });
    }

    String getName() {
        return this.name;
    }

    boolean isLeader() {
        return this.leader;
    }

    boolean setLeader(boolean bl) {
        boolean bl2 = this.leader != bl;
        this.leader = bl;
        return bl2;
    }

    boolean isPresent() {
        return this.present;
    }

    void setPresent(boolean bl) {
        this.present = bl;
    }

    float getHpRatio() {
        return (float)this.hpModel.getValue();
    }

    void setHpRatio(float f) {
        this.hpModel.setValue(f);
    }

    void setChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
    }

    void setMaxHPRepresentation(int n) {
        this.hpModel.setMaxRepresentation(n);
    }

    public boolean equals(Object object) {
        if (object instanceof Member) {
            return this.name.equals(((Member)object).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Member member) {
        if (this.leader != member.leader) {
            return this.leader ? -1 : 1;
        }
        return this.name.compareToIgnoreCase(member.name);
    }
}

