/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.imageviewer;

import games.stendhal.client.gui.imageviewer.ImageViewPanel;
import games.stendhal.client.gui.imageviewer.ImageViewWindow;
import games.stendhal.client.sprite.DataLoader;
import java.net.URL;
import marauroa.common.game.RPEvent;
import org.apache.log4j.Logger;

public final class RPEventImageViewer {
    private String path;
    private String caption;
    private String title;
    private static final Logger logger = Logger.getLogger(RPEventImageViewer.class);

    private RPEventImageViewer(RPEvent rPEvent) {
        if (rPEvent.has("path")) {
            this.path = rPEvent.get("path");
        }
        if (rPEvent.has("caption")) {
            this.caption = rPEvent.get("caption");
        }
        if (rPEvent.has("title")) {
            this.title = rPEvent.get("title");
        }
        this.view();
    }

    public static void viewImage(RPEvent rPEvent) {
        new RPEventImageViewer(rPEvent);
    }

    private URL genURL() {
        try {
            URL uRL = null;
            uRL = this.path.startsWith("http://") || this.path.startsWith("https://") ? new URL(this.path) : DataLoader.getResource(this.path);
            return uRL;
        }
        catch (Exception exception) {
            logger.error(null, (Throwable)exception);
            return null;
        }
    }

    private void view() {
        URL uRL = this.genURL();
        if (uRL != null) {
            ImageViewPanel imageViewPanel = new ImageViewPanel(uRL, this.caption);
            new ImageViewWindow(this.title, imageViewPanel);
        } else {
            logger.error((Object)("No such image: " + this.path));
        }
    }
}

