/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameLoop;
import games.stendhal.client.GameObjects;
import games.stendhal.client.PerceptionListenerImpl;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.UserContext;
import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.Initializer;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.J2DClientGUI;
import games.stendhal.client.gui.ManagedWindow;
import games.stendhal.client.gui.NotificationChannelManager;
import games.stendhal.client.gui.SwingClientGUI;
import games.stendhal.client.gui.UserInterface;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.listener.PositionChangeListener;
import games.stendhal.client.listener.PositionChangeMulticaster;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.SoundSystemFacade;
import games.stendhal.client.sound.nosound.NoSoundFacade;
import games.stendhal.client.sound.sound.SoundSystemFacadeImpl;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.common.Debug;
import games.stendhal.common.NotificationType;
import games.stendhal.common.constants.SoundLayer;
import java.awt.Frame;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import marauroa.client.BannedAddressException;
import marauroa.client.TimeoutException;
import marauroa.client.net.IPerceptionListener;
import marauroa.common.game.RPObject;
import marauroa.common.net.InvalidVersionException;
import org.apache.log4j.Logger;

public class j2DClient
implements UserInterface {
    private static final Logger logger;
    private static j2DClient sharedUI;
    private final NotificationChannelManager channelManager = new NotificationChannelManager();
    private User lastuser;
    private final PositionChangeMulticaster positionChangeListener = new PositionChangeMulticaster();
    private final J2DClientGUI gui;
    private StendhalClient client;
    private SoundSystemFacade soundSystemFacade;
    private boolean gameRunning;
    private boolean debugEnabled = false;
    private final IPerceptionListener perceptionListener = new PerceptionListenerImpl(){
        int times;

        @Override
        public void onSynced() {
            j2DClient.this.gui.setOffline(false);
            this.times = 0;
            logger.debug((Object)"Synced with server state.");
            j2DClient.this.addEventLine(new HeaderLessEventLine("Zsynchronizowany", NotificationType.CLIENT));
        }

        @Override
        public void onUnsynced() {
            ++this.times;
            if (this.times > 3) {
                logger.debug((Object)"Request resync");
                j2DClient.this.addEventLine(new HeaderLessEventLine("Niezsynchronizowany: Synchronizuj\u0119...", NotificationType.CLIENT));
            }
        }
    };

    public static j2DClient get() {
        return sharedUI;
    }

    private static void setDefault(j2DClient j2DClient2) {
        sharedUI = j2DClient2;
        ClientSingletonRepository.setUserInterface(j2DClient2);
    }

    public j2DClient(J2DClientGUI j2DClientGUI) {
        j2DClient.setDefault(this);
        this.gui = j2DClientGUI;
    }

    public j2DClient(StendhalClient stendhalClient, UserContext userContext, JFrame jFrame) {
        this.client = stendhalClient;
        j2DClient.setDefault(this);
        SlashActionRepository.register();
        this.gui = new SwingClientGUI(stendhalClient, userContext, this.channelManager, jFrame);
        for (PositionChangeListener positionChangeListener : this.gui.getPositionChangeListeners()) {
            this.positionChangeListener.add(positionChangeListener);
        }
        if (Debug.PRE_RELEASE_VERSION != null) {
            this.addEventLine(new HeaderLessEventLine("To jest klient testowy wersji wst\u0119pnej: 1.40.3 - " + Debug.PRE_RELEASE_VERSION, NotificationType.CLIENT));
        }
        this.checkAndComplainAboutJavaImplementation();
        this.positionChangeListener.add(this.getSoundSystemFacade());
    }

    private void checkAndComplainAboutJavaImplementation() {
        String string = System.getProperty("java.vm.name", "unknown").toLowerCase(Locale.ENGLISH);
        if (string.indexOf("hotspot") < 0 && string.indexOf("openjdk") < 0) {
            String string2 = "PolanieOnLine jest przeznaczona i testowana dla Oracle Java i OpenJDK. U\u017cywasz " + System.getProperty("java.vm.vendor", "unknown") + " " + System.getProperty("java.vm.name", "unknown") + ". Mog\u0105 wynika\u0107 problemy takie jak: czarny lub szary ekran.\n Je\u017celi masz do\u015bwiadczenie w programowaniu z JDK to zapraszamy do wsp\u00f3\u0142pracy.";
            this.addEventLine(new HeaderLessEventLine(string2, NotificationType.ERROR));
        }
    }

    public void startGameLoop() {
        Object object;
        try {
            object = this.initSoundSystem();
            object.play("ui/login", 0, null, null, false, true);
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
        }
        object = GameLoop.get();
        GameObjects gameObjects = this.client.getGameObjects();
        ((GameLoop)object).runAllways(n -> this.gameLoop(n, gameObjects));
        ((GameLoop)object).runAtQuit(this::cleanup);
        this.gameRunning = true;
        ((GameLoop)object).start();
    }

    private void cleanup() {
        WtWindowManager.getInstance().save();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                logger.warn((Object)"Forced exit, sound system likely locked up");
                System.exit(1);
            }
        };
        Executors.newSingleThreadScheduledExecutor().schedule(runnable, 3L, TimeUnit.SECONDS);
        this.getSoundSystemFacade().exit();
        logger.debug((Object)"Exit");
        System.exit(0);
    }

    private void gameLoop(int n, GameObjects gameObjects) {
        if (!this.gameRunning) {
            this.tryLogout();
        }
        this.gui.setOffline(!this.client.getConnectionState());
        this.gui.beforePainting();
        logger.debug((Object)"Move objects");
        gameObjects.update(n);
        User user = User.get();
        if (user != null && user != this.lastuser) {
            this.gui.updateUser(user);
            this.lastuser = user;
        }
        this.gui.triggerPainting();
        logger.debug((Object)"Query network");
        this.client.loop(0);
        this.gui.afterPainting();
    }

    private void tryLogout() {
        logger.info((Object)"Request logout");
        try {
            if (this.gui.isOffline() || this.client.logout()) {
                GameLoop.get().stop();
            } else {
                logger.warn((Object)"You can't logout now.");
                this.gameRunning = true;
            }
        }
        catch (BannedAddressException | TimeoutException | InvalidVersionException throwable) {
            logger.error((Object)throwable, throwable);
            GameLoop.get().stop();
        }
    }

    private SoundGroup initSoundSystem() {
        SoundGroup soundGroup = this.getSoundSystemFacade().getGroup(SoundLayer.USER_INTERFACE.groupName);
        soundGroup.loadSound("ui/login", "ui/login.ogg", SoundFileType.OGG, false);
        soundGroup.loadSound("ui/window_fold", "ui/window_fold.ogg", SoundFileType.OGG, false);
        return soundGroup;
    }

    void shutdown() {
        this.gameRunning = false;
    }

    public void addWindow(ManagedWindow managedWindow) {
        if (!(managedWindow instanceof InternalManagedWindow)) {
            throw new IllegalArgumentException("Unsupport ManagedWindow type: " + managedWindow.getClass().getName());
        }
        this.gui.addDialog((InternalManagedWindow)managedWindow);
    }

    public void requestQuit() {
        this.gui.requestQuit(this.client);
    }

    public void getVisibleRunicAltar() {
        this.gui.getVisibleRunicAltar();
    }

    @Override
    public void addEventLine(EventLine eventLine) {
        this.channelManager.addEventLine(eventLine);
    }

    @Override
    @Deprecated
    public void addGameScreenText(double d, double d2, String string, NotificationType notificationType, boolean bl) {
        this.gui.addGameScreenText(d, d2, string, notificationType, bl);
    }

    @Override
    @Deprecated
    public void addGameScreenText(Entity entity, String string, NotificationType notificationType, boolean bl) {
        this.gui.addGameScreenText(entity, string, notificationType, bl);
    }

    @Override
    public void addAchievementBox(String string, String string2, String string3) {
        this.gui.addAchievementBox(string, string2, string3);
    }

    public void chooseOutfit() {
        this.gui.chooseOutfit();
    }

    public Frame getMainFrame() {
        return this.gui.getFrame();
    }

    public void resetClientDimensions() {
        this.gui.resetClientDimensions();
    }

    public void setChatLine(String string) {
        this.gui.setChatLine(string);
    }

    public void clearGameLog() {
        this.channelManager.getVisibleChannel().clear();
    }

    public void setPosition(double d, double d2) {
        this.positionChangeListener.positionChanged(d, d2);
    }

    public IPerceptionListener getPerceptionListener() {
        return this.perceptionListener;
    }

    public StendhalClient getClient() {
        return this.client;
    }

    @Override
    public final SoundSystemFacade getSoundSystemFacade() {
        if (this.soundSystemFacade == null) {
            try {
                this.soundSystemFacade = DataLoader.getResource("data/sounds/ui/login.ogg") != null || DataLoader.getResource("data/music/the_old_tavern.ogg") != null ? new SoundSystemFacadeImpl() : new NoSoundFacade();
            }
            catch (RuntimeException runtimeException) {
                this.soundSystemFacade = new NoSoundFacade();
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
        return this.soundSystemFacade;
    }

    public void switchToSpellState(RPObject rPObject) {
        this.gui.switchToSpellState(rPObject);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public void toggleDebugEnabled() {
        this.debugEnabled = !this.debugEnabled;
    }

    static {
        Initializer.init();
        logger = Logger.getLogger(j2DClient.class);
    }
}

